/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.api.ExtensionException;

public class ColorSchemesPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    JSpinner colorSizeJSpinner;
    JComboBox<String> schemeJComboBox;
    ColorSchemesComboBox legendJComboBox;
    JLabel legendLabel;
    JLabel statusLabel;
    String colorSchemeType = "Sequential";
    String colorLegendName = "YlOrBr";
    int colorSchemeSize = 5;
    int[][] colorSchemeRGBArray;
    static final int START_INDEX = 0;
    static final int LEGEND_LABEL_SIZE = 30;
    static final int MAX_LEGEND_LABEL = 12;

    public ColorSchemesPanel(JLabel statusLabel_) throws ExtensionException {
        this.statusLabel = statusLabel_;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        this.add((Component)topPanel, "Center");
        String[] schemeType = new String[]{"Sequential", "Divergent", "Qualitative"};
        this.schemeJComboBox = new JComboBox<String>(schemeType);
        this.schemeJComboBox.setSelectedIndex(0);
        topPanel.add(this.schemeJComboBox);
        this.schemeJComboBox.addActionListener(this);
        this.legendJComboBox = new ColorSchemesComboBox("Sequential", this);
        topPanel.add(this.legendJComboBox);
        this.legendJComboBox.addActionListener(this);
        int SequencialSchemeMaxSize = ColorSchemes.getMaximumLegendSize("Sequential");
        SpinnerNumberModel colorNumberModel = new SpinnerNumberModel(5, 3, SequencialSchemeMaxSize, 1);
        this.colorSizeJSpinner = new JSpinner(colorNumberModel);
        topPanel.add(this.colorSizeJSpinner);
        this.colorSizeJSpinner.addChangeListener(this);
        this.legendLabel = new JLabel();
        ColorSchemesIconImage initialIcon = new ColorSchemesIconImage(ColorSchemes.getRGBArray(this.colorSchemeType, this.colorLegendName, this.colorSchemeSize), 30);
        this.legendLabel.setIcon(initialIcon);
        Dimension dim0 = new Dimension(360, 30);
        this.legendLabel.setPreferredSize(dim0);
        topPanel.add(this.legendLabel);
        this.colorSchemeSize = colorNumberModel.getNumber().intValue();
        this.colorSchemeType = (String)this.schemeJComboBox.getSelectedItem();
        this.colorLegendName = ((ImageIcon)this.legendJComboBox.getSelectedItem()).getDescription();
        Dimension dim1 = new Dimension(this.schemeJComboBox.getPreferredSize().width + this.legendJComboBox.getPreferredSize().width + this.colorSizeJSpinner.getPreferredSize().width + 360 + 30, 70);
        this.setSize(dim1);
        this.setPreferredSize(dim1);
        this.statusLabel.setText(" \"" + this.colorSchemeType + "\"  \"" + this.colorLegendName + "\" " + this.colorSchemeSize);
    }

    public void setLegend(String colorSchemeType, String colorLegendName, int colorSchemeSize) throws ExtensionException {
        this.colorSchemeType = colorSchemeType;
        this.colorLegendName = colorLegendName;
        this.colorSchemeSize = colorSchemeSize;
        this.legendJComboBox.setModelFromString(colorSchemeType);
        this.colorSizeJSpinner.setValue(colorSchemeSize);
        ColorSchemesIconImage initialIcon = new ColorSchemesIconImage(ColorSchemes.getRGBArray(colorSchemeType, colorLegendName, colorSchemeSize), 30);
        this.legendLabel.setIcon(initialIcon);
    }

    public int[][] getColorSchemeRGBArray() throws ExtensionException {
        return ColorSchemes.getRGBArray(this.colorSchemeType, this.colorLegendName, this.colorSchemeSize);
    }

    public Color[] getColorSchemeColorArray() throws ExtensionException {
        return ColorSchemes.getColorArray(this.colorSchemeType, this.colorLegendName, this.colorSchemeSize);
    }

    public String getColorSchemeString() {
        return this.colorSchemeType + " " + this.colorLegendName + " " + String.valueOf(this.colorSchemeSize);
    }

    public boolean legendExists(String LegendName) throws ExtensionException {
        this.colorSchemeRGBArray = ColorSchemes.getRGBArray(this.colorSchemeType, LegendName, this.colorSchemeSize);
        return this.colorSchemeRGBArray != null;
    }

    public void displayLegend() throws ExtensionException {
        this.colorSchemeRGBArray = ColorSchemes.getRGBArray(this.colorSchemeType, this.colorLegendName, this.colorSchemeSize);
        if (this.colorSchemeRGBArray != null) {
            this.legendLabel.setText(null);
            this.legendLabel.setIcon(new ColorSchemesIconImage(ColorSchemes.getRGBArray(this.colorSchemeType, this.colorLegendName, this.colorSchemeSize), 30));
        } else {
            this.legendLabel.setIcon(null);
            if (this.colorSchemeType.equals("Sequential")) {
                this.legendLabel.setText("<html>No sequential scheme available, select less or equal than 9</html>");
            }
            if (this.colorSchemeType.equals("Divergent")) {
                this.legendLabel.setText("<html>No Divergent scheme available, select less or equal than 11</html>");
            }
            if (this.colorSchemeType.equals("Qualitative")) {
                this.legendLabel.setText("<html>Choose an enabled legend</html>");
                if (!this.legendJComboBox.isPopupVisible()) {
                    this.legendJComboBox.showPopup();
                }
            }
        }
    }

    public void displayLegend(String colorLegendName) throws ExtensionException {
        this.colorSchemeRGBArray = ColorSchemes.getRGBArray(this.colorSchemeType, colorLegendName, this.colorSchemeSize);
        if (this.colorSchemeRGBArray != null) {
            this.legendLabel.setText(null);
            this.legendLabel.setIcon(new ColorSchemesIconImage(ColorSchemes.getRGBArray(this.colorSchemeType, colorLegendName, this.colorSchemeSize), 30));
        } else {
            this.legendLabel.setIcon(null);
            if (this.colorSchemeType.equals("Sequential")) {
                this.legendLabel.setText("No sequential scheme available, select less or equal than 9");
            }
            if (this.colorSchemeType.equals("Divergent")) {
                this.legendLabel.setText("No Divergent scheme available, select less or equal than 11");
            }
            if (this.colorSchemeType.equals("Qualitative")) {
                this.legendLabel.setText("<html>Choose an enabled legend</html>");
                if (!this.legendJComboBox.isPopupVisible()) {
                    this.legendJComboBox.showPopup();
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.colorSchemeType = this.schemeJComboBox.getSelectedItem().toString();
        this.legendJComboBox.setModelFromString(this.colorSchemeType);
        this.colorLegendName = ((ImageIcon)this.legendJComboBox.getSelectedItem()).getDescription();
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.colorSizeJSpinner.getModel();
        ImageIcon icon = (ImageIcon)this.legendJComboBox.getSelectedItem();
        this.colorLegendName = icon.getDescription();
        Object schemeArray = new int[][][]{};
        try {
            schemeArray = ColorSchemes.getRGBArray(this.colorSchemeType, this.colorLegendName);
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        this.colorSchemeSize = ((int[][][])schemeArray).length + 2;
        SpinnerNumberModel legendSpinner = new SpinnerNumberModel(Math.min(spinnerNumberModel.getNumber().intValue(), this.colorSchemeSize), 3, this.colorSchemeSize, 1);
        this.colorSchemeSize = Math.min(spinnerNumberModel.getNumber().intValue(), this.colorSchemeSize);
        this.colorSizeJSpinner.setModel(legendSpinner);
        try {
            this.displayLegend();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        this.statusLabel.setText(" \"" + this.colorSchemeType + "\"  \"" + this.colorLegendName + "\" " + this.colorSchemeSize);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.colorSizeJSpinner.getModel();
        this.colorSchemeSize = numberModel.getNumber().intValue();
        try {
            this.displayLegend();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        this.legendJComboBox.repaint();
        this.statusLabel.setText(" \"" + this.colorSchemeType + "\"  \"" + this.colorLegendName + "\" " + this.colorSchemeSize);
    }
}

