/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;

public class HSBUpdated {
    public static LogoList updateHSB(LogoList rgb, double newVal, int ind) {
        double alpha = 255.0;
        if (rgb.length() > 3) {
            alpha = (Double)rgb.get(3);
        }
        newVal = ind == 0 ? HSBUpdated.modDouble(newVal, 360.0) : (ind == 1 ? Math.min(100.0, Math.max(newVal, 0.0)) : Math.min(100.0, Math.max(newVal, 0.0)));
        LogoList hsb = org.nlogo.api.Color.getHSBListByRGBList((LogoList)rgb);
        LogoListBuilder newHSB = new LogoListBuilder();
        for (int i = 0; i < 3; ++i) {
            if (i == ind) {
                newHSB.add((Object)newVal);
                continue;
            }
            newHSB.add(hsb.get(i));
        }
        hsb = newHSB.toLogoList();
        LogoList newRGB = HSBUpdated.HSBtoRGB(hsb);
        LogoListBuilder finalRGBA = new LogoListBuilder();
        for (int i = 0; i < 3; ++i) {
            finalRGBA.add(newRGB.get(i));
        }
        if (alpha != 255.0) {
            finalRGBA.add((Object)alpha);
        }
        return finalRGBA.toLogoList();
    }

    public static LogoList HSBtoRGB(LogoList hsb) {
        Double h = new Double((Double)hsb.get(0));
        Double s = new Double((Double)hsb.get(1));
        Double b = new Double((Double)hsb.get(2));
        int newRGBint = Color.HSBtoRGB(h.floatValue() / 360.0f, s.floatValue() / 100.0f, b.floatValue() / 100.0f);
        LogoListBuilder rgb = new LogoListBuilder();
        int shift = 16;
        for (int i = 0; i < 3; ++i) {
            rgb.add((Object)(newRGBint >> shift & 0xFF));
            shift -= 8;
        }
        return rgb.toLogoList();
    }

    public static double modDouble(double a, double b) {
        while (a < 0.0) {
            a += b;
        }
        while (a >= b) {
            a -= b;
        }
        return a;
    }
}

