/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public final class InputMethodClientImpl
implements InputMethodClient,
ExtendedInputMethodRequests {
    private static final Logger log = Logger.getLogger(InputMethodClientImpl.class.getName());
    private final WeakReference<WebView> wvRef;
    private final WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView wv, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(wv);
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean doActivate) {
        WebView wv = (WebView)this.wvRef.get();
        if (wv != null && wv.getScene() != null) {
            wv.getScene().impl_enableInputMethodEvents(doActivate);
        }
        this.state = doActivate;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent ie) {
        ArrayList<Integer> underlines = new ArrayList<Integer>();
        StringBuilder composed = new StringBuilder();
        int pos = 0;
        for (InputMethodTextRun run : ie.getComposed()) {
            String rawText = run.getText();
            InputMethodHighlight imh = run.getHighlight();
            underlines.add(pos);
            underlines.add(pos + rawText.length());
            underlines.add(imh == InputMethodHighlight.SELECTED_CONVERTED || imh == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            pos += rawText.length();
            composed.append(rawText);
        }
        int size = underlines.size();
        if (size == 0) {
            underlines.add(0);
            underlines.add(pos);
            underlines.add(0);
            size = underlines.size();
        }
        int[] attributes = new int[size];
        for (int i = 0; i < size; ++i) {
            attributes[i] = (Integer)underlines.get(i);
        }
        return new WCInputMethodEvent(ie.getCommitted(), composed.toString(), attributes, ie.getCaretPosition());
    }

    @Override
    public Point2D getTextLocation(int offset) {
        FutureTask<Point2D> f = new FutureTask<Point2D>(() -> {
            int[] loc = this.webPage.getClientTextLocation(offset);
            WCPoint point = this.webPage.getPageClient().windowToScreen(new WCPoint(loc[0], loc[1] + loc[3]));
            return new Point2D(point.getIntX(), point.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(f);
        Point2D result = null;
        try {
            result = f.get();
        }
        catch (ExecutionException ex) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation " + ex);
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation InterruptedException" + ex);
        }
        return result;
    }

    @Override
    public int getLocationOffset(int x, int y) {
        FutureTask<Integer> f = new FutureTask<Integer>(() -> {
            WCPoint point = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
            return this.webPage.getClientLocationOffset(x - point.getIntX(), y - point.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(f);
        int location = 0;
        try {
            location = f.get();
        }
        catch (ExecutionException ex) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getLocationOffset " + ex);
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, "InputMethodClientImpl.getTextLocation InterruptedException" + ex);
        }
        return location;
    }

    @Override
    public void cancelLatestCommittedText() {
    }

    @Override
    public String getSelectedText() {
        return this.webPage.getClientSelectedText();
    }

    @Override
    public int getInsertPositionOffset() {
        return this.webPage.getClientInsertPositionOffset();
    }

    @Override
    public String getCommittedText(int begin, int end) {
        try {
            return this.webPage.getClientCommittedText().substring(begin, end);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getCommittedTextLength() {
        return this.webPage.getClientCommittedTextLength();
    }
}

