/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.ConvexHullFlatnessAlgo;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public class ConvexHullSubdivCriterion
extends ConvexHullFlatnessAlgo
implements QuadSubdivisionCriterion,
CubicSubdivisionCriterion {
    public static double minTolerance = 1.25 * Math.sqrt(Double.MIN_VALUE);
    protected double sqTol = 1.0E-10;

    public ConvexHullSubdivCriterion() {
        this(1.0E-5);
    }

    public ConvexHullSubdivCriterion(double tolerance) {
        if (tolerance < 0.0) {
            tolerance = -tolerance;
        }
        if (0.0 == tolerance) {
            tolerance = 2.0 * Math.sqrt(Double.MIN_VALUE);
        }
        if (tolerance < minTolerance) {
            tolerance = minTolerance;
        }
        this.sqTol = tolerance * tolerance;
    }

    public final boolean shouldSplit(CubicCurve2D curve) {
        double defect = this.getSquaredFlatness(curve);
        return defect > this.sqTol;
    }

    public final boolean shouldSplit(QuadCurve2D curve) {
        double defect = this.getSquaredFlatness(curve);
        return defect > this.sqTol;
    }
}

