/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.samples;

import com.caffeineowl.graphics.samples.BezierPanelListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BezierPanel
extends JPanel {
    private static final long serialVersionUID = 4502036303710475820L;
    protected int oldW = 200;
    protected int oldH = 200;
    protected Point2D c0 = new Point2D.Double();
    protected Point2D c1 = new Point2D.Double();
    protected Point2D p0 = new Point2D.Double();
    protected Point2D p1 = new Point2D.Double();
    protected Point2D lastClicked = null;
    protected boolean representingCubic = true;
    protected boolean labelsShown = true;
    protected Paint curvePaint = Color.BLACK;
    protected Paint handlePaint = Color.LIGHT_GRAY;
    protected Paint dotPaint = Color.RED;
    protected ArrayList listeners = new ArrayList();
    private boolean notifyListeners = true;

    public BezierPanel() {
        this.setBackground(Color.WHITE);
        this.p0.setLocation(50.0, 180.0);
        this.p1.setLocation(150.0, 180.0);
        this.c0.setLocation(180.0, 50.0);
        this.c1.setLocation(20.0, 50.0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point loc = e.getPoint();
                BezierPanel.this.mouseSelection(loc);
            }

            public void mouseReleased(MouseEvent e) {
                BezierPanel.this.lastClicked = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (null != BezierPanel.this.lastClicked && e.getX() >= 0 && e.getX() < BezierPanel.this.getWidth() && e.getY() >= 0 && e.getY() < BezierPanel.this.getHeight()) {
                    BezierPanel.this.lastClicked.setLocation(e.getPoint());
                    BezierPanel.this.dragGesture();
                }
            }
        });
    }

    public void addCurveChangeListener(BezierPanelListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeCurveChangeListener(BezierPanelListener listener) {
        this.listeners.remove(listener);
    }

    protected BezierPanelListener[] getBezierPanelListeners() {
        BezierPanelListener[] toRet = new BezierPanelListener[this.listeners.size()];
        this.listeners.toArray(toRet);
        return toRet;
    }

    protected void dragGesture() {
        this.fireCurveChanged();
        this.repaint(50L);
    }

    protected void fireCurveChanged() {
        if (this.notifyListeners) {
            BezierPanelListener[] lists = this.getBezierPanelListeners();
            for (int i = 0; i < lists.length; ++i) {
                lists[i].curveChanged(this);
            }
        }
    }

    public CubicCurve2D getRepresentedCubic() {
        CubicCurve2D.Double toRet = new CubicCurve2D.Double();
        toRet.setCurve(this.p0, this.c0, this.c1, this.p1);
        return toRet;
    }

    public void setRepresentedCubic(CubicCurve2D c) {
        if (null != c) {
            this.p0.setLocation(c.getP1());
            this.p1.setLocation(c.getP2());
            this.c0.setLocation(c.getCtrlP1());
            this.c1.setLocation(c.getCtrlP2());
            this.dragGesture();
        }
    }

    public QuadCurve2D getRepresentedQuad() {
        QuadCurve2D.Double toRet = new QuadCurve2D.Double();
        toRet.setCurve(this.p0, this.c0, this.p1);
        return toRet;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (w != 0 && h != 0) {
            this.c0.setLocation(this.c0.getX() / (double)this.oldW * (double)w, this.c0.getY() / (double)this.oldH * (double)h);
            this.c1.setLocation(this.c1.getX() / (double)this.oldW * (double)w, this.c1.getY() / (double)this.oldH * (double)h);
            this.p0.setLocation(this.p0.getX() / (double)this.oldW * (double)w, this.p0.getY() / (double)this.oldH * (double)h);
            this.p1.setLocation(this.p1.getX() / (double)this.oldW * (double)w, this.p1.getY() / (double)this.oldH * (double)h);
            this.oldW = w;
            this.oldH = h;
        }
    }

    protected void paintComponent(Graphics g) {
        Shape cu;
        super.paintComponent(g);
        double midX = (this.p0.getX() + this.p1.getX()) / 2.0;
        double midY = (this.p0.getY() + this.p1.getY()) / 2.0;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape c = null;
        if (this.isRepresentingCubic()) {
            cu = new CubicCurve2D.Double();
            ((CubicCurve2D)cu).setCurve(this.p0, this.c0, this.c1, this.p1);
            c = cu;
        } else {
            cu = new QuadCurve2D.Double();
            ((QuadCurve2D)cu).setCurve(this.p0, this.c0, this.p1);
            c = cu;
        }
        g2.setPaint(this.curvePaint);
        g2.setStroke(new BasicStroke(2.0f));
        g2.draw(c);
        Line2D.Double line = new Line2D.Double();
        g2.setPaint(this.handlePaint);
        g2.setStroke(new BasicStroke(0.5f));
        line.setLine(this.p0, this.c0);
        g2.draw(line);
        if (this.isRepresentingCubic()) {
            line.setLine(this.p1, this.c1);
        } else {
            line.setLine(this.p1, this.c0);
        }
        g2.draw(line);
        g2.setPaint(this.dotPaint);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrame(this.p0.getX() - 2.0, this.p0.getY() - 2.0, 5.0, 5.0);
        g2.fill(rect);
        rect.setFrame(this.p1.getX() - 2.0, this.p1.getY() - 2.0, 5.0, 5.0);
        g2.fill(rect);
        rect.setFrame(this.c0.getX() - 2.0, this.c0.getY() - 2.0, 5.0, 5.0);
        g2.fill(rect);
        if (this.labelsShown) {
            this.drawLabel(g2, "P1", midX + 1.1 * (this.p0.getX() - midX), midY + 1.1 * (this.p0.getY() - midY));
            this.drawLabel(g2, "P2", midX + 1.1 * (this.p1.getX() - midX), midY + 1.1 * (this.p1.getY() - midY));
        }
        if (this.isRepresentingCubic()) {
            this.drawLabel(g2, "C1", midX + 1.1 * (this.c0.getX() - midX), midY + 1.1 * (this.c0.getY() - midY));
            rect.setFrame(this.c1.getX() - 2.0, this.c1.getY() - 2.0, 5.0, 5.0);
            g2.fill(rect);
            if (this.labelsShown) {
                this.drawLabel(g2, "C2", midX + 1.1 * (this.c1.getX() - midX), midY + 1.1 * (this.c1.getY() - midY));
            }
        } else {
            this.drawLabel(g2, "C", midX + 1.1 * (this.c0.getX() - midX), midY + 1.1 * (this.c0.getY() - midY));
        }
    }

    public Paint getCurvePaint() {
        return this.curvePaint;
    }

    public Paint getDotPaint() {
        return this.dotPaint;
    }

    public Paint getHandlePaint() {
        return this.handlePaint;
    }

    public void setCurvePaint(Paint paint) {
        this.curvePaint = paint;
    }

    public void setDotPaint(Paint paint) {
        this.dotPaint = paint;
    }

    public void setHandlePaint(Paint paint) {
        this.handlePaint = paint;
    }

    public boolean isRepresentingCubic() {
        return this.representingCubic;
    }

    public void setRepresentingCubic(boolean b) {
        this.representingCubic = b;
        if (this.isDisplayable()) {
            this.repaint(50L);
        }
    }

    protected void drawLabel(Graphics2D g2, String label, double x, double y) {
        Font labelFont = new Font("monospaced", 1, 11);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(label, labelFont, frc);
        Rectangle2D rect = tl.getBounds();
        tl.draw(g2, (float)(x - rect.getWidth() / 2.0), (float)(y - rect.getHeight()));
    }

    protected void fillDiamond(Graphics2D g2, double x, double y, GeneralPath aux) {
        if (null == aux) {
            aux = new GeneralPath();
        } else {
            aux.reset();
        }
        aux.moveTo((float)x, (float)y - 4.0f);
        aux.lineTo((float)(x - 3.0), (float)y);
        aux.lineTo((float)x, (float)(y + 4.0));
        aux.lineTo((float)(x + 3.0), (float)y);
        aux.closePath();
        g2.fill(aux);
    }

    protected void drawDiamond(Graphics2D g2, double x, double y, GeneralPath aux) {
        if (null == aux) {
            aux = new GeneralPath();
        } else {
            aux.reset();
        }
        aux.moveTo((float)x, (float)y - 4.0f);
        aux.lineTo((float)(x - 3.0), (float)y);
        aux.lineTo((float)x, (float)(y + 4.0));
        aux.lineTo((float)(x + 3.0), (float)y);
        aux.closePath();
        g2.draw(aux);
    }

    protected void mouseSelection(Point2D loc) {
        if (loc.distance(this.p0) < 3.0) {
            this.lastClicked = this.p0;
        } else if (loc.distance(this.p1) < 3.0) {
            this.lastClicked = this.p1;
        } else if (loc.distance(this.c0) < 3.0) {
            this.lastClicked = this.c0;
        } else if (this.representingCubic && loc.distance(this.c1) < 3.0) {
            this.lastClicked = this.c1;
        }
    }
}

