/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;

public class BootstrapUtility {
    private static final int N_TRIAL_MAX = 16;
    private static final int N_TRIAL_MIN = 3;
    private static final double TRIAL_FACTOR = 0.3333333333333333;
    private static final double MIN_AREA_FACTOR = Math.sqrt(3.0) / 4.0 / 64.0;
    private final double triangleMinAreaThreshold;
    private final GeometricOperations geoOp;
    final Random random = new Random(0L);

    public BootstrapUtility(Thresholds thresholds) {
        this.triangleMinAreaThreshold = thresholds.getNominalPointSpacing() * MIN_AREA_FACTOR;
        this.geoOp = new GeometricOperations(thresholds);
    }

    private int computeNumberOfTrials(int nVertices) {
        int nTrial = (int)Math.pow(nVertices, 0.3333333333333333);
        if (nTrial < 3) {
            nTrial = 3;
        } else if (nTrial > 16) {
            nTrial = 16;
        }
        return nTrial;
    }

    public Vertex[] bootstrap(List<Vertex> list) {
        if (list.size() < 3) {
            return null;
        }
        Vertex[] v = new Vertex[3];
        Vertex[] vtest = new Vertex[3];
        int n = list.size();
        int nTrial = this.computeNumberOfTrials(n);
        double bestScore = Double.NEGATIVE_INFINITY;
        for (int iTrial = 0; iTrial < nTrial; ++iTrial) {
            if (n == 3) {
                vtest[0] = list.get(0);
                vtest[1] = list.get(1);
                vtest[2] = list.get(2);
            } else {
                for (int i = 0; i < 3; ++i) {
                    block2: do {
                        int index = this.random.nextInt(n);
                        vtest[i] = list.get(index);
                        for (int j = 0; j < i; ++j) {
                            if (vtest[j] != vtest[i]) continue;
                            vtest[i] = null;
                            continue block2;
                        }
                    } while (vtest[i] == null);
                }
            }
            double a = this.geoOp.area(vtest[0], vtest[1], vtest[2]);
            if (a == 0.0) continue;
            if (a < 0.0) {
                Vertex swap = vtest[0];
                vtest[0] = vtest[2];
                vtest[2] = swap;
                a = -a;
            }
            if (!(a > bestScore)) continue;
            bestScore = a;
            v[0] = vtest[0];
            v[1] = vtest[1];
            v[2] = vtest[2];
        }
        if (bestScore >= this.triangleMinAreaThreshold) {
            return v;
        }
        if (n == 3) {
            return null;
        }
        ArrayList<Vertex> testList = new ArrayList<Vertex>(3);
        BootstrapTestResult testResult = this.testInput(list, testList);
        if (testResult == BootstrapTestResult.Valid) {
            v[0] = (Vertex)testList.get(0);
            v[1] = (Vertex)testList.get(1);
            v[2] = (Vertex)testList.get(2);
            return v;
        }
        if (testResult != BootstrapTestResult.Unknown) {
            return null;
        }
        for (int i = 0; i < n - 2; ++i) {
            vtest[0] = list.get(i);
            for (int j = i + 1; j < n - 1; ++j) {
                vtest[1] = list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    vtest[2] = list.get(k);
                    double a = this.geoOp.area(vtest[0], vtest[1], vtest[2]);
                    double aAbs = Math.abs(a);
                    if (!(aAbs > bestScore)) continue;
                    bestScore = aAbs;
                    if (a < 0.0) {
                        v[0] = vtest[2];
                        v[1] = vtest[1];
                        v[2] = vtest[0];
                    } else {
                        v[0] = vtest[0];
                        v[1] = vtest[1];
                        v[2] = vtest[2];
                    }
                    if (!(aAbs >= this.triangleMinAreaThreshold)) continue;
                    return v;
                }
            }
        }
        return null;
    }

    public BootstrapTestResult testInput(List<Vertex> input, List<Vertex> output) {
        double y;
        double x;
        if (input == null || input.size() < 3) {
            return BootstrapTestResult.InsufficientPointSet;
        }
        if (output != null) {
            output.clear();
        }
        int n = input.size();
        double XY = 0.0;
        double X2 = 0.0;
        double Y2 = 0.0;
        double xBar = 0.0;
        double yBar = 0.0;
        for (Vertex v : input) {
            x = v.getX();
            y = v.getY();
            xBar += x;
            yBar += y;
        }
        xBar /= (double)input.size();
        yBar /= (double)input.size();
        for (Vertex v : input) {
            x = v.getX() - xBar;
            y = v.getY() - yBar;
            XY += x * y;
            X2 += x * x;
            Y2 += y * y;
        }
        Thresholds thresholds = this.geoOp.getThresholds();
        double samePoint2 = thresholds.getVertexTolerance2();
        if (X2 <= samePoint2 && Y2 <= samePoint2) {
            return BootstrapTestResult.TrivialPointSet;
        }
        double twoTheta = Math.atan2(2.0 * XY, X2 - Y2);
        double sin2T = Math.sin(twoTheta);
        double cos2T = Math.cos(twoTheta);
        double secondDrv = 2.0 * (X2 - Y2) * cos2T + 4.0 * XY * sin2T;
        double theta = twoTheta / 2.0;
        if (secondDrv < -thresholds.getHalfPlaneThreshold()) {
            theta += 1.5707963267948966;
        }
        double uX = Math.cos(theta);
        double uY = Math.sin(theta);
        double pX = -uY;
        double pY = uX;
        double sMax = Double.NEGATIVE_INFINITY;
        int iMax = -1;
        Vertex a = null;
        for (int i = 0; i < n; ++i) {
            double y2;
            Vertex v = input.get(i);
            double x2 = v.getX() - xBar;
            double s = Math.abs(x2 * pX + (y2 = v.getY() - yBar) * pY);
            if (!(s > sMax)) continue;
            sMax = s;
            iMax = i;
            a = v;
        }
        if (sMax < thresholds.getHalfPlaneThreshold()) {
            return BootstrapTestResult.CollinearPointSet;
        }
        double tMin = Double.POSITIVE_INFINITY;
        double tMax = Double.NEGATIVE_INFINITY;
        Vertex b = null;
        Vertex c = null;
        for (int i = 0; i < n; ++i) {
            double y3;
            if (i == iMax) continue;
            Vertex v = input.get(i);
            double x3 = v.getX() - xBar;
            double t = Math.abs(x3 * pX + (y3 = v.getY() - yBar) * pY);
            if (t > tMax) {
                tMax = t;
                b = v;
            }
            if (!(t < tMin)) continue;
            tMin = t;
            c = v;
        }
        if (a == null || b == null || c == null) {
            return BootstrapTestResult.InsufficientPointSet;
        }
        double area = Math.abs(this.geoOp.area(a, b, c));
        if (a.getDistance(c) > a.getDistance(b)) {
            Vertex swap = b;
            b = c;
            c = swap;
        }
        double areaMax = area;
        Vertex vMax = c;
        int nTrial = this.computeNumberOfTrials(n);
        for (int iTrial = 0; iTrial < nTrial; ++iTrial) {
            int index = this.random.nextInt(n);
            Vertex v = input.get(index);
            area = Math.abs(this.geoOp.area(a, b, v));
            if (!(area > areaMax)) continue;
            areaMax = area;
            vMax = v;
        }
        c = vMax;
        if (areaMax < this.triangleMinAreaThreshold) {
            for (Vertex v : input) {
                area = Math.abs(this.geoOp.area(a, b, v));
                if (!(area > this.triangleMinAreaThreshold)) continue;
                c = v;
                break;
            }
        }
        if ((area = this.geoOp.area(a, b, c)) < 0.0) {
            Vertex swap = b;
            b = c;
            c = swap;
            area = -area;
        }
        if (area > this.triangleMinAreaThreshold) {
            if (output != null) {
                output.add(a);
                output.add(b);
                output.add(c);
            }
            return BootstrapTestResult.Valid;
        }
        return BootstrapTestResult.Unknown;
    }

    public static enum BootstrapTestResult {
        InsufficientPointSet,
        TrivialPointSet,
        CollinearPointSet,
        Valid,
        Unknown;

    }
}

