/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.standard.IncrementalTin;

public class TinInstantiationUtility {
    public static final double DEFAULT_MEMORY_FRACTION = 0.6;
    public static final long MEMORY_FOR_VIRTUAL = 120L;
    public static final long MEMORY_FOR_STANDARD = 240L;
    private final int nVertices;
    private final long maxMemoryBytes;
    private final long maxAllowedForUse;
    private final long nBytesNeededForStandard;
    private final long nBytesNeededForVirtual;
    private final Class<?> tinClass;

    private TinInstantiationUtility() {
        this.nVertices = 0;
        this.maxAllowedForUse = 0L;
        this.maxMemoryBytes = 0L;
        this.nBytesNeededForStandard = 0L;
        this.nBytesNeededForVirtual = 0L;
        this.tinClass = null;
    }

    public TinInstantiationUtility(double memoryUseFraction, int nVertices) {
        if (memoryUseFraction < 0.0 || memoryUseFraction > 1.0) {
            throw new IllegalArgumentException("Memory use fraction " + memoryUseFraction + " is not in range 0 to 1");
        }
        if (nVertices < 3) {
            throw new IllegalArgumentException("Number of vertices " + nVertices + " is less than minimum of 3");
        }
        this.nVertices = nVertices;
        this.maxMemoryBytes = Runtime.getRuntime().maxMemory();
        this.maxAllowedForUse = (long)((double)this.maxMemoryBytes * memoryUseFraction);
        this.nBytesNeededForStandard = (long)nVertices * 240L;
        this.nBytesNeededForVirtual = (long)nVertices * 120L;
        this.tinClass = this.nBytesNeededForStandard < this.maxAllowedForUse ? IncrementalTin.class : SemiVirtualIncrementalTin.class;
    }

    public IIncrementalTin constructInstance(Class<?> tinClass, double nominalPointSpacing) {
        Class<?>[] interfaces;
        if (tinClass == null) {
            throw new IllegalArgumentException("Null specification for TIN class");
        }
        boolean failedToImplement = true;
        for (Class<?> c : interfaces = tinClass.getInterfaces()) {
            if (!c.equals(IIncrementalTin.class)) continue;
            failedToImplement = false;
            break;
        }
        if (failedToImplement) {
            throw new IllegalArgumentException("Specified class does not implement IIncrementalTin: " + tinClass.getName());
        }
        Double pointSpacing = 0.0 <= nominalPointSpacing && nominalPointSpacing < Double.POSITIVE_INFINITY ? Double.valueOf(nominalPointSpacing) : new Double(1.0);
        Constructor<?> constructor = null;
        try {
            Constructor<?>[] allConstructors;
            for (Constructor<?> c : allConstructors = tinClass.getDeclaredConstructors()) {
                Class<?>[] pTypes = c.getParameterTypes();
                if (pTypes.length != 1 || pTypes[0] != Double.TYPE) continue;
                constructor = c;
                break;
            }
            if (constructor == null) {
                throw new IllegalArgumentException("TIN class does not specify a constructor with one double argument giving nominal point spacing: " + tinClass.getName());
            }
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("No-argument constructor not available for " + tinClass.getName(), ex);
        }
        try {
            return (IIncrementalTin)constructor.newInstance(pointSpacing);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Unable to instantiate class " + tinClass.getName(), ex);
        }
    }

    public IIncrementalTin constructInstance(double nominalPointSpacing) {
        return this.constructInstance(this.tinClass, nominalPointSpacing);
    }

    public void printSummary(PrintStream ps) {
        ps.format("Number of vertices used for calculation:    %8d%n", this.nVertices);
        ps.format("Memory limit for JVM:                       %12.3f megabytes%n", (double)this.maxMemoryBytes / 1024.0 / 1024.0);
        ps.format("Rule of thumb threshold for method choice:  %12.3f megabytes%n", (double)this.maxAllowedForUse / 1024.0 / 1024.0);
        ps.format("Memory required for standard edge class:    %12.3f megabytes%n", (double)this.nBytesNeededForStandard / 1024.0 / 1024.0);
        ps.format("Memory required for semi-virtual edge class:%12.3f megabytes%n", (double)this.nBytesNeededForVirtual / 1024.0 / 1024.0);
        ps.format("Selected class:                             %s%n", this.tinClass.getName());
    }

    public Class<?> getTinClass() {
        return this.tinClass;
    }
}

