/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.util.StringUtils;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.Nobody$;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp abstract class VectorDatasetSearch {
    static String getPropertyName(VectorDataset dataset, Argument arg) throws ExtensionException, LogoException {
        String propertyName = arg.getString().toUpperCase();
        if (dataset.isValidPropertyName(propertyName)) {
            return propertyName;
        }
        throw new ExtensionException("dataset does not have property: '" + propertyName + "'");
    }

    public strictfp static final class GetMaximum
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()}, (int)(Syntax.NumberType() | Syntax.StringType()));
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            Comparable result = null;
            for (VectorFeature feature : dataset.getFeatures()) {
                Object value = feature.getProperty(propertyName);
                if (value == null || result != null && result.compareTo(value) >= 0 || value instanceof Number && Double.isNaN(((Number)value).doubleValue())) continue;
                result = (Comparable)value;
            }
            return result;
        }
    }

    public strictfp static final class GetMinimum
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()}, (int)(Syntax.NumberType() | Syntax.StringType()));
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            Comparable result = null;
            for (VectorFeature feature : dataset.getFeatures()) {
                Object value = feature.getProperty(propertyName);
                if (value == null || result != null && result.compareTo(value) <= 0 || value instanceof Number && Double.isNaN(((Number)value).doubleValue())) continue;
                result = (Comparable)value;
            }
            return result;
        }
    }

    public strictfp static final class FindInRange
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType(), Syntax.StringType() | Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            Comparable min = (Comparable)args[2].get();
            Comparable max = (Comparable)args[3].get();
            LogoListBuilder result = new LogoListBuilder();
            for (VectorFeature feature : dataset.getFeatures()) {
                Object value = feature.getProperty(propertyName);
                if (value == null || min.compareTo(value) >= 0 || max.compareTo(value) <= 0) continue;
                result.add((Object)feature);
            }
            return result.toLogoList();
        }
    }

    public strictfp static final class FindGreaterThan
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            Comparable min = (Comparable)args[2].get();
            LogoListBuilder result = new LogoListBuilder();
            for (VectorFeature feature : dataset.getFeatures()) {
                Object value = feature.getProperty(propertyName);
                if (value == null || min.compareTo(value) >= 0) continue;
                result.add((Object)feature);
            }
            return result.toLogoList();
        }
    }

    public strictfp static final class FindLessThan
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            Comparable max = (Comparable)args[2].get();
            LogoListBuilder result = new LogoListBuilder();
            for (VectorFeature feature : dataset.getFeatures()) {
                Object value = feature.getProperty(propertyName);
                if (value == null || max.compareTo(value) <= 0) continue;
                result.add((Object)feature);
            }
            return result.toLogoList();
        }
    }

    public strictfp static final class FindAll
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            LogoListBuilder result = new LogoListBuilder();
            if (args[2].get() instanceof String) {
                StringUtils.WildcardMatcher matcher = new StringUtils.WildcardMatcher(args[2].getString());
                for (VectorFeature feature : dataset.getFeatures()) {
                    Object value = feature.getProperty(propertyName);
                    if (value == null || !matcher.matches(value.toString())) continue;
                    result.add((Object)feature);
                }
            } else {
                Double number = args[2].getDouble();
                for (VectorFeature feature : dataset.getFeatures()) {
                    Object value = feature.getProperty(propertyName);
                    if (value == null || !value.equals(number)) continue;
                    result.add((Object)feature);
                }
            }
            return result.toLogoList();
        }
    }

    public strictfp static final class FindOne
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorDataset dataset = VectorDataset.getDataset(args[0]);
            String propertyName = VectorDatasetSearch.getPropertyName(dataset, args[1]);
            if (args[2].get() instanceof String) {
                StringUtils.WildcardMatcher matcher = new StringUtils.WildcardMatcher(args[2].getString());
                for (VectorFeature feature : dataset.getFeatures()) {
                    Object value = feature.getProperty(propertyName);
                    if (value == null || !matcher.matches(value.toString())) continue;
                    return feature;
                }
            } else {
                Double number = args[2].getDouble();
                for (VectorFeature feature : dataset.getFeatures()) {
                    Object value = feature.getProperty(propertyName);
                    if (value == null || !value.equals(number)) continue;
                    return feature;
                }
            }
            return Nobody$.MODULE$;
        }
    }
}

