/*
 * Decompiled with CFR 0.152.
 */
package view25d;

import java.util.ArrayList;
import java.util.HashMap;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import view25d.prims.DecoratePatchView;
import view25d.prims.GetObserverAngles;
import view25d.prims.GetObserverDistance;
import view25d.prims.GetObserverFocus;
import view25d.prims.GetZScale;
import view25d.prims.MakePatchView;
import view25d.prims.MakeTurtleView;
import view25d.prims.SetLinkDisplayMode;
import view25d.prims.SetObserverAngles;
import view25d.prims.SetObserverDistance;
import view25d.prims.SetObserverFocus;
import view25d.prims.SetTurtleStemColor;
import view25d.prims.SetTurtleStemThickness;
import view25d.prims.SetZScale;
import view25d.prims.UpdateAllViews;
import view25d.prims.UpdateOnePatchView;
import view25d.prims.UpdateOneTurtleView;
import view25d.view.PatchView;
import view25d.view.TurtleView;
import view25d.view.VarviewWindow;
import view25d.view.View25DShapeChangeListener;

public class View25DExtension
extends DefaultClassManager {
    public static HashMap<String, PatchView> patchWindowMap = new HashMap();
    public static HashMap<String, TurtleView> turtleWindowMap = new HashMap();

    public static int numWindows() {
        return turtleWindowMap.size() + patchWindowMap.size();
    }

    public static void storePatchWindowWithTitle(String s, PatchView win) {
        View25DExtension.removePatchWindowWithTitle(s);
        patchWindowMap.put(s, win);
    }

    public static void removePatchWindowWithTitle(String name) {
        if (patchWindowMap.containsKey(name)) {
            VarviewWindow vvw = patchWindowMap.get(name);
            patchWindowMap.remove(name);
            vvw.dispose();
        }
    }

    public static void storeTurtleWindowWithTitle(String s, TurtleView win) {
        View25DExtension.removeTurtleWindowWithTitle(s);
        turtleWindowMap.put(s, win);
    }

    public static void removeTurtleWindowWithTitle(String name) {
        if (turtleWindowMap.containsKey(name)) {
            VarviewWindow tvw = turtleWindowMap.get(name);
            turtleWindowMap.remove(name);
            tvw.dispose();
        }
    }

    public static void updateTurtleShapesAllViews() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(turtleWindowMap.keySet());
        for (String name : names) {
            TurtleView tv = turtleWindowMap.get(name);
            tv.updateTurtleShapes();
        }
        names.clear();
        names.addAll(patchWindowMap.keySet());
        for (String name : names) {
            PatchView pv = patchWindowMap.get(name);
            pv.updateTurtleShapes();
        }
    }

    public void runOnce(ExtensionManager em) throws ExtensionException {
        View25DShapeChangeListener.listen();
    }

    public void load(PrimitiveManager primManager) throws ExtensionException {
        primManager.addPrimitive("patch-view", (Primitive)new MakePatchView());
        primManager.addPrimitive("decorate-patch-view", (Primitive)new DecoratePatchView(true));
        primManager.addPrimitive("undecorate-patch-view", (Primitive)new DecoratePatchView(false));
        primManager.addPrimitive("turtle-view", (Primitive)new MakeTurtleView());
        primManager.addPrimitive("update-patch-view", (Primitive)new UpdateOnePatchView());
        primManager.addPrimitive("update-all-patch-views", (Primitive)new UpdateAllViews());
        primManager.addPrimitive("update-turtle-view", (Primitive)new UpdateOneTurtleView());
        primManager.addPrimitive("remove-patch-view", (Primitive)new RemoveOnePatchView());
        primManager.addPrimitive("remove-turtle-view", (Primitive)new RemoveOneTurtleView());
        primManager.addPrimitive("remove-all-patch-views", (Primitive)new RemoveAllPatchViews());
        primManager.addPrimitive("remove-all-turtle-views", (Primitive)new RemoveAllTurtleViews());
        primManager.addPrimitive("count-windows", (Primitive)new GetWindowCount());
        primManager.addPrimitive("set-z-scale", (Primitive)new SetZScale());
        primManager.addPrimitive("get-z-scale", (Primitive)new GetZScale());
        primManager.addPrimitive("set-turtle-stem-thickness", (Primitive)new SetTurtleStemThickness());
        primManager.addPrimitive("set-turtle-stem-color", (Primitive)new SetTurtleStemColor());
        primManager.addPrimitive("get-observer-angles", (Primitive)new GetObserverAngles());
        primManager.addPrimitive("set-observer-angles", (Primitive)new SetObserverAngles());
        primManager.addPrimitive("get-observer-distance", (Primitive)new GetObserverDistance());
        primManager.addPrimitive("set-observer-distance", (Primitive)new SetObserverDistance());
        primManager.addPrimitive("get-observer-xy-focus", (Primitive)new GetObserverFocus());
        primManager.addPrimitive("set-observer-xy-focus", (Primitive)new SetObserverFocus());
        primManager.addPrimitive("show-links-xy-plane", (Primitive)new SetLinkDisplayMode(true));
        primManager.addPrimitive("show-links-xyz", (Primitive)new SetLinkDisplayMode(false));
    }

    public static void disposeAllPatchViews() {
        for (VarviewWindow varviewWindow : patchWindowMap.values()) {
            if (varviewWindow == null) continue;
            varviewWindow.dispose();
        }
    }

    public static void disposeAllTurtleViews() {
        for (TurtleView tv : turtleWindowMap.values()) {
            if (tv == null) continue;
            tv.dispose();
        }
    }

    public void unload(ExtensionManager em) {
        View25DExtension.disposeAllPatchViews();
        View25DExtension.disposeAllTurtleViews();
    }

    public static class RemoveAllPatchViews
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            ArrayList<String> namesToDelete = new ArrayList<String>();
            namesToDelete.addAll(patchWindowMap.keySet());
            for (String name : namesToDelete) {
                VarviewWindow vvw = patchWindowMap.get(name);
                patchWindowMap.remove(name);
                vvw.dispose();
            }
        }
    }

    public static class RemoveAllTurtleViews
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            ArrayList<String> namesToDelete = new ArrayList<String>();
            namesToDelete.addAll(turtleWindowMap.keySet());
            for (String name : namesToDelete) {
                VarviewWindow tvw = turtleWindowMap.get(name);
                turtleWindowMap.remove(name);
                tvw.dispose();
            }
        }
    }

    public static class RemoveOneTurtleView
    implements Command {
        public Syntax getSyntax() {
            int[] argType = new int[]{Syntax.StringType()};
            return SyntaxJ.commandSyntax((int[])argType);
        }

        public void perform(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            String title = args[0].getString();
            View25DExtension.removeTurtleWindowWithTitle(title);
        }
    }

    public static class RemoveOnePatchView
    implements Command {
        public Syntax getSyntax() {
            int[] argType = new int[]{Syntax.StringType()};
            return SyntaxJ.commandSyntax((int[])argType);
        }

        public void perform(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            String title = args[0].getString();
            View25DExtension.removePatchWindowWithTitle(title);
        }
    }

    public static class GetWindowCount
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.NumberType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            return (double)View25DExtension.numWindows();
        }
    }
}

