/*
 * Decompiled with CFR 0.152.
 */
package view25d.prims;

import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import view25d.View25DExtension;
import view25d.view.MouseableGLWindow;
import view25d.view.VarviewWindow;

public class SetObserverAngles
implements Command {
    public Syntax getSyntax() {
        int[] argTypes = new int[]{Syntax.StringType(), Syntax.NumberType(), Syntax.NumberType()};
        return SyntaxJ.commandSyntax((int[])argTypes, (String)"O---");
    }

    public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
        double delPitch;
        double oldPitch;
        double delHeading;
        double oldHeading;
        double[] headingAndPitch;
        MouseableGLWindow win;
        String whichView = args[0].getString();
        double newHeading = args[1].getDoubleValue();
        double newPitch = args[2].getDoubleValue();
        VarviewWindow vvwp = View25DExtension.patchWindowMap.get(whichView);
        VarviewWindow vvwt = View25DExtension.turtleWindowMap.get(whichView);
        if (vvwp != null) {
            win = vvwp.getGLWindow();
            headingAndPitch = win.getObserverPerspectiveAngles();
            oldHeading = headingAndPitch[0];
            delHeading = newHeading - oldHeading;
            oldPitch = headingAndPitch[1];
            delPitch = -1.0 * (newPitch - oldPitch);
            win.updateObserverPerspectiveAnglesWithDeltas(delHeading, delPitch);
        }
        if (vvwt != null) {
            win = vvwt.getGLWindow();
            headingAndPitch = win.getObserverPerspectiveAngles();
            oldHeading = headingAndPitch[0];
            delHeading = newHeading - oldHeading;
            oldPitch = headingAndPitch[1];
            delPitch = -1.0 * (newPitch - oldPitch);
            win.updateObserverPerspectiveAnglesWithDeltas(delHeading, delPitch);
        }
    }
}

