/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.nlogo.app.App;
import org.nlogo.core.ShapeList;
import org.nlogo.gl.render.Polygons;
import org.nlogo.gl.render.Tessellator;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Curve;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import scala.collection.JavaConverters;
import scala.collection.Set;
import view25d.view.Observer;
import view25d.view.VarviewWindow;
import view25d.view.gl.NetLogoGLU;

public abstract class MouseableGLWindow
extends MouseAdapter {
    protected VarviewWindow myViewer;
    protected Observer observer = new Observer(0.0, 0.0, 49.5);
    protected GLCanvas myCanvas;
    protected int oldx;
    protected int oldy;
    public boolean dragging = false;
    public HashMap<String, Integer> compiledShapes;
    public NetLogoGLU nlGLU = new NetLogoGLU();
    public boolean areShapesStale = false;
    public GLU glu;

    public void updateObserverPerspectiveAnglesWithDeltas(double thetax, double thetay) {
        this.observer.updatePerspectiveAngles(thetax, thetay);
        this.myCanvas.repaint();
    }

    public double[] getObserverPerspectiveAngles() {
        return new double[]{this.observer.heading, this.observer.pitch};
    }

    public void shiftObserverFocusPoint(double deltax, double deltay) {
        this.observer.objectiveShift(deltax, deltay);
        this.myCanvas.repaint();
    }

    public double[] getObserverPerspectiveFocusPoint() {
        return new double[]{this.observer.rotx, this.observer.roty};
    }

    public void zoomToDistance(double dist) {
        this.observer.zoomToDistance(dist);
        this.myCanvas.repaint();
    }

    public double getObserverDistance() {
        return this.observer.dist();
    }

    public MouseableGLWindow(VarviewWindow parent) {
        this.myViewer = parent;
    }

    public void setCanvas(GLCanvas glCanvas) {
        this.myCanvas = glCanvas;
    }

    public void repaintCanvas() {
        this.myCanvas.repaint();
    }

    protected void setupLightingAndViewPort(GL2 gl, GLU glu) {
        gl.glShadeModel(7425);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4353);
        gl.glEnable(2896);
        float[] direction1 = new float[]{-1.0f, -0.3f, 0.4f, 0.0f};
        float[] ambient1 = new float[]{0.25f, 0.25f, 0.25f, 1.0f};
        float[] diffuse1 = new float[]{0.35f, 0.35f, 0.35f, 1.0f};
        float[] specular1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        gl.glLightfv(1, 4611, FloatBuffer.wrap(direction1));
        gl.glLightfv(1, 4608, FloatBuffer.wrap(ambient1));
        gl.glLightfv(1, 4609, FloatBuffer.wrap(diffuse1));
        gl.glLightfv(1, 4610, FloatBuffer.wrap(specular1));
        gl.glEnable(1);
        float[] direction2 = new float[]{1.0f, 0.6f, -0.5f, 0.0f};
        float[] ambient2 = new float[]{0.25f, 0.25f, 0.25f, 1.0f};
        float[] diffuse2 = new float[]{0.35f, 0.35f, 0.35f, 1.0f};
        float[] specular2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        gl.glLightfv(2, 4611, FloatBuffer.wrap(direction2));
        gl.glLightfv(2, 4608, FloatBuffer.wrap(ambient2));
        gl.glLightfv(2, 4609, FloatBuffer.wrap(diffuse2));
        gl.glLightfv(2, 4610, FloatBuffer.wrap(specular2));
        gl.glEnable(2);
        float SHINE_ALL_DIRECTIONS = 1.0f;
        float[] lightPos = new float[]{(float)(1.2 * (double)this.myViewer.maxPxcor), (float)(1.2 * (double)this.myViewer.maxPycor), 70.0f, SHINE_ALL_DIRECTIONS};
        float[] lightColorAmbient = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
        float[] lightColorSpecular = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
        gl.glLightfv(16385, 4611, lightPos, 0);
        gl.glLightfv(16385, 4608, lightColorAmbient, 0);
        gl.glLightfv(16385, 4610, lightColorSpecular, 0);
        gl.glEnable(16385);
        gl.glEnable(2977);
        gl.glColorMaterial(1028, 5634);
        gl.glEnable(2903);
        int[] StencilBits = new int[1];
        gl.glGetIntegerv(3415, IntBuffer.wrap(StencilBits));
        this.mainViewport(gl, glu);
    }

    protected void mainViewport(GL2 gl, GLU glu) {
        int worldWidth = this.myViewer.worldWidth;
        int worldHeight = this.myViewer.worldHeight;
        double ratio = (double)worldWidth / (double)worldHeight;
        ratio = 1.0;
        gl.glViewport(0, 0, worldWidth, worldHeight);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        double zClip = Math.max(worldWidth, worldHeight) * 40;
        glu.gluPerspective(45.0, ratio, 0.1, zClip);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.observer.goHome(this.myViewer);
    }

    protected void setColorAndStandardMaterial(GL2 gl, float red, float green, float blue) {
        float[] rgba = new float[]{red, green, blue};
        gl.glMaterialfv(1028, 4608, rgba, 0);
        gl.glMaterialfv(1028, 4610, rgba, 0);
        gl.glMaterialf(1028, 5633, 0.5f);
        gl.glColor3f(red, green, blue);
    }

    protected void drawAxesIfDragging(GL2 gl, int axisHeadHandle) {
        if (this.dragging) {
            double zmax = 10.0 * this.myViewer.zScale + 1.0;
            float red = 0.9f;
            float green = 0.0f;
            float blue = 0.0f;
            this.setColorAndStandardMaterial(gl, red, green, blue);
            gl.glLineWidth(2.4f);
            gl.glBegin(1);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3i(this.myViewer.maxPxcor + 1, 0, 0);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3d(0.0, (double)(this.myViewer.maxPycor + 1), 0.0);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3d(0.0, 0.0, zmax);
            gl.glVertex3i(0, 0, 0);
            gl.glEnd();
            gl.glPushMatrix();
            gl.glTranslated((double)(this.myViewer.maxPxcor + 1), 0.0, 0.0);
            gl.glRotated(90.0, 0.0, 1.0, 0.0);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(0.0, (double)(this.myViewer.maxPycor + 1), 0.0);
            gl.glRotated(-90.0, 1.0, 0.0, 0.0);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(0.0, 0.0, zmax);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int nx = me.getX();
        int ny = me.getY();
        if (this.myViewer.getMode() == 0) {
            double thetaX = (double)(nx - this.oldx) / 2.0;
            double thetaY = (double)(this.oldy - ny) / 2.0;
            this.observer.updatePerspectiveAngles(thetaX, thetaY);
        } else if (this.myViewer.getMode() == 1) {
            double deltax = (double)(nx - this.oldx) / 2.0;
            double deltay = (double)(this.oldy - ny) / 2.0;
            this.observer.shift(deltax, deltay);
        } else if (this.myViewer.getMode() == 2) {
            double deldist = this.oldy - ny;
            this.observer.zoomby(deldist);
        } else if (this.myViewer.getMode() == 3) {
            double deldist = (double)(this.oldy - ny) / 30.0;
            this.myViewer.zoomZby(deldist);
        }
        this.oldx = nx;
        this.oldy = ny;
        this.myCanvas.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me) {
        this.observer.zoomby(me.getPreciseWheelRotation());
        this.myCanvas.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.oldx = me.getX();
        this.oldy = me.getY();
        this.dragging = true;
        this.myCanvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.dragging = false;
        this.myCanvas.repaint();
    }

    public void compileShape(NetLogoGLU nlGLU, GL2 gl, GLU glu, VectorShape vShape, int index, boolean rotatable) {
        Tessellator tessellator = new Tessellator();
        GLUtessellator tess = GLU.gluNewTess();
        GLU.gluTessCallback((GLUtessellator)tess, (int)100106, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100110, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100107, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100108, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100111, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100109, (GLUtessellatorCallback)tessellator);
        GLU.gluTessProperty((GLUtessellator)tess, (int)100140, (double)100130.0);
        gl.glNewList(index, 4864);
        if (!rotatable) {
            gl.glDisable(2896);
        }
        List elements = vShape.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if (element instanceof Rectangle) {
                nlGLU.renderRectangle(gl, i, (Rectangle)element, rotatable);
                continue;
            }
            if (element instanceof Polygon) {
                Polygons.renderPolygon((GL2)gl, (GLU)glu, (Tessellator)tessellator, (GLUtessellator)tess, (int)i, (Polygon)((Polygon)element), (boolean)rotatable, (boolean)false);
                continue;
            }
            if (element instanceof Circle) {
                nlGLU.renderCircle(gl, glu, i, (Circle)element, rotatable);
                continue;
            }
            if (element instanceof Line) {
                nlGLU.renderLine(gl, i, (Line)element);
                continue;
            }
            if (!(element instanceof Curve)) continue;
            throw new IllegalStateException();
        }
        if (!rotatable) {
            gl.glEnable(2896);
        }
        gl.glDisable(2884);
        gl.glEndList();
    }

    public void compileShapes(GL2 gl, HashMap<String, Integer> compiledShapes, boolean isRotatable) {
        java.util.Set names = JavaConverters.setAsJavaSet((Set)App.app().workspace().world().turtleShapeList().names());
        for (String name : names) {
            if (!names.contains(name)) continue;
            int handle = gl.glGenLists(1);
            VectorShape vs = (VectorShape)App.app().workspace().world().turtleShapeList().shape(name);
            this.compileShape(this.nlGLU, gl, this.glu, vs, handle, false);
            compiledShapes.put(name, handle);
        }
    }

    public void setDeletedShapesToDefaultShape(HashMap<String, Integer> compiledShapes) {
        java.util.Set names = JavaConverters.setAsJavaSet((Set)App.app().workspace().world().turtleShapeList().names());
        HashSet<String> lostKeys = new HashSet<String>(compiledShapes.keySet());
        lostKeys.removeAll(names);
        for (String name : lostKeys) {
            compiledShapes.put(name, compiledShapes.get(ShapeList.DefaultShapeName()));
        }
    }

    public void updateTurtleDisplayList() {
        this.areShapesStale = true;
    }
}

