/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;

final class SSLEngineInputRecord
extends InputRecord
implements SSLRecord {
    private boolean formatVerified = false;
    private ByteBuffer handshakeBuffer = null;

    SSLEngineInputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLReadCipher.nullTlsReadCipher());
    }

    @Override
    int estimateFragmentSize(int n) {
        if (n > 0) {
            return this.readCipher.estimateFragmentSize(n, 5);
        }
        return 16384;
    }

    @Override
    int bytesInCompletePacket(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.bytesInCompletePacket(byteBufferArray[n]);
    }

    private int bytesInCompletePacket(ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.remaining() < 5) {
            return -1;
        }
        int n = byteBuffer.position();
        byte by = byteBuffer.get(n);
        int n2 = 0;
        if (this.formatVerified || by == ContentType.HANDSHAKE.id || by == ContentType.ALERT.id) {
            byte by2;
            byte by3 = byteBuffer.get(n + 1);
            if (!ProtocolVersion.isNegotiable(by3, by2 = byteBuffer.get(n + 2), false)) {
                throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(by3, by2) + " , plaintext connection?");
            }
            this.formatVerified = true;
            n2 = ((byteBuffer.get(n + 3) & 0xFF) << 8) + (byteBuffer.get(n + 4) & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (by & 0x80) != 0;
            if (bl && (byteBuffer.get(n + 2) == 1 || byteBuffer.get(n + 2) == 4)) {
                byte by4;
                byte by5 = byteBuffer.get(n + 3);
                if (!ProtocolVersion.isNegotiable(by5, by4 = byteBuffer.get(n + 4), false)) {
                    throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(by5, by4) + " , plaintext connection?");
                }
                int n3 = bl ? 127 : 63;
                n2 = ((by & n3) << 8) + (byteBuffer.get(n + 1) & 0xFF) + (bl ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n2;
    }

    @Override
    Plaintext[] decode(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException, BadPaddingException {
        if (byteBufferArray == null || byteBufferArray.length == 0 || n2 == 0) {
            return new Plaintext[0];
        }
        if (n2 == 1) {
            return this.decode(byteBufferArray[n]);
        }
        ByteBuffer byteBuffer = SSLEngineInputRecord.extract(byteBufferArray, n, n2, 5);
        return this.decode(byteBuffer);
    }

    private Plaintext[] decode(ByteBuffer byteBuffer) throws IOException, BadPaddingException {
        if (this.isClosed) {
            return null;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            SSLLogger.fine("Raw read", byteBuffer);
        }
        if (!this.formatVerified) {
            this.formatVerified = true;
            int n = byteBuffer.position();
            byte by = byteBuffer.get(n);
            if (by != ContentType.HANDSHAKE.id && by != ContentType.ALERT.id) {
                return this.handleUnknownRecord(byteBuffer);
            }
        }
        return this.decodeInputRecord(byteBuffer);
    }

    private Plaintext[] decodeInputRecord(ByteBuffer byteBuffer) throws IOException, BadPaddingException {
        ByteBuffer byteBuffer2;
        Object object;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        int n3 = Record.getInt16(byteBuffer);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(by2, by3) + " " + ContentType.nameOf(by) + ", length = " + n3, new Object[0]);
        }
        if (n3 < 0 || n3 > 33088) {
            throw new SSLProtocolException("Bad input record size, TLSCiphertext.length = " + n3);
        }
        int n4 = n + 5 + n3;
        byteBuffer.limit(n4);
        byteBuffer.position(n + 5);
        try {
            object = this.readCipher.decrypt(by, byteBuffer, null);
            byteBuffer2 = ((Plaintext)object).fragment;
            by = ((Plaintext)object).contentType;
        }
        catch (BadPaddingException badPaddingException) {
            throw badPaddingException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLProtocolException)new SSLProtocolException("Unexpected exception").initCause(generalSecurityException);
        }
        finally {
            byteBuffer.limit(n2);
            byteBuffer.position(n4);
        }
        if (by != ContentType.HANDSHAKE.id && this.handshakeBuffer != null && this.handshakeBuffer.hasRemaining()) {
            throw new SSLProtocolException("Expecting a handshake fragment, but received " + ContentType.nameOf(by));
        }
        if (by == ContentType.HANDSHAKE.id) {
            Object object2;
            object = byteBuffer2;
            if (this.handshakeBuffer != null && this.handshakeBuffer.remaining() != 0) {
                object2 = ByteBuffer.wrap(new byte[this.handshakeBuffer.remaining() + byteBuffer2.remaining()]);
                ((ByteBuffer)object2).put(this.handshakeBuffer);
                ((ByteBuffer)object2).put(byteBuffer2);
                object = (ByteBuffer)((ByteBuffer)object2).rewind();
                this.handshakeBuffer = null;
            }
            object2 = new ArrayList(5);
            while (((Buffer)object).hasRemaining()) {
                int n5 = ((Buffer)object).remaining();
                if (n5 < 4) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n5]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                ((ByteBuffer)object).mark();
                byte by4 = ((ByteBuffer)object).get();
                int n6 = Record.getInt24((ByteBuffer)object);
                if (n6 > SSLConfiguration.maxHandshakeMessageSize) {
                    throw new SSLProtocolException("The size of the handshake message (" + n6 + ") exceeds the maximum allowed size (" + SSLConfiguration.maxHandshakeMessageSize + ")");
                }
                ((ByteBuffer)object).reset();
                int n7 = 4 + n6;
                if (n5 < n7) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n5]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                if (n5 == n7) {
                    if (this.handshakeHash.isHashable(by4)) {
                        this.handshakeHash.receive((ByteBuffer)object);
                    }
                    ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, (ByteBuffer)object));
                    break;
                }
                int n8 = ((Buffer)object).position();
                int n9 = ((Buffer)object).limit();
                int n10 = n8 + n7;
                ((ByteBuffer)object).limit(n10);
                if (this.handshakeHash.isHashable(by4)) {
                    this.handshakeHash.receive((ByteBuffer)object);
                }
                ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, ((ByteBuffer)object).slice()));
                ((ByteBuffer)object).position(n10);
                ((ByteBuffer)object).limit(n9);
            }
            return ((ArrayList)object2).toArray(new Plaintext[0]);
        }
        return new Plaintext[]{new Plaintext(by, by2, by3, -1, -1L, byteBuffer2)};
    }

    private Plaintext[] handleUnknownRecord(ByteBuffer byteBuffer) throws IOException, BadPaddingException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byte by = byteBuffer.get(n);
        byte by2 = byteBuffer.get(n + 2);
        if ((by & 0x80) != 0 && by2 == 1) {
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is not enabled");
            }
            byte by3 = byteBuffer.get(n + 3);
            byte by4 = byteBuffer.get(n + 4);
            if (by3 == ProtocolVersion.SSL20Hello.major && by4 == ProtocolVersion.SSL20Hello.minor) {
                if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                    SSLLogger.fine("Requested to negotiate unsupported SSLv2!", new Object[0]);
                }
                throw new UnsupportedOperationException("Unsupported SSL v2.0 ClientHello");
            }
            byteBuffer.position(n + 2);
            this.handshakeHash.receive(byteBuffer);
            byteBuffer.position(n);
            ByteBuffer byteBuffer2 = SSLEngineInputRecord.convertToClientHello(byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("[Converted] ClientHello", byteBuffer2);
            }
            return new Plaintext[]{new Plaintext(ContentType.HANDSHAKE.id, by3, by4, -1, -1L, byteBuffer2)};
        }
        if ((by & 0x80) != 0 && by2 == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        throw new SSLException("Unsupported or unrecognized SSL message");
    }
}

