/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.contacts;

import java.io.Serializable;

public enum OnlineStatus implements Serializable
{
    OFFLINE(0),
    AWAY(1),
    ONLINE(2),
    UNKNOWN(100);

    private static final long serialVersionUID = 12L;
    private final int type;

    private OnlineStatus(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static OnlineStatus fromType(int type) {
        switch (type) {
            case 0: {
                return OFFLINE;
            }
            case 1: {
                return AWAY;
            }
            case 2: {
                return ONLINE;
            }
            case 100: {
                return UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unsupported online type: " + type);
    }

    public static OnlineStatus fromType(String type) {
        if (type == null || "".equals(type)) {
            return UNKNOWN;
        }
        return OnlineStatus.fromType(Integer.parseInt(type));
    }

    static class OnlineStatusType {
        static final int OFFLINE_TYPE = 0;
        static final int AWAY_TYPE = 1;
        static final int ONLINE_TYPE = 2;
        static final int UNKNOWN_TYPE = 100;

        OnlineStatusType() {
        }
    }
}

