/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ext.typographic.internal.AngleQuoteDelimiterProcessor;
import com.vladsch.flexmark.ext.typographic.internal.DoubleQuoteDelimiterProcessor;
import com.vladsch.flexmark.ext.typographic.internal.SingleQuoteDelimiterProcessor;
import com.vladsch.flexmark.ext.typographic.internal.SmartsInlineParser;
import com.vladsch.flexmark.ext.typographic.internal.TypographicNodeRenderer;
import com.vladsch.flexmark.ext.typographic.internal.TypographicOptions;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;

public class TypographicExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension {
    public static final DataKey<Boolean> ENABLE_QUOTES = new DataKey("ENABLE_QUOTES", (Object)true);
    public static final DataKey<Boolean> ENABLE_SMARTS = new DataKey("ENABLE_SMARTS", (Object)true);
    public static final DataKey<Boolean> TYPOGRAPHIC_QUOTES = ENABLE_QUOTES;
    public static final DataKey<Boolean> TYPOGRAPHIC_SMARTS = ENABLE_SMARTS;
    public static final DataKey<String> ANGLE_QUOTE_CLOSE = new DataKey("ANGLE_QUOTE_CLOSE", (Object)"&raquo;");
    public static final DataKey<String> ANGLE_QUOTE_OPEN = new DataKey("ANGLE_QUOTE_OPEN", (Object)"&laquo;");
    public static final DataKey<String> ANGLE_QUOTE_UNMATCHED = new DataKey("ANGLE_QUOTE_UNMATCHED", (Object)null);
    public static final DataKey<String> DOUBLE_QUOTE_CLOSE = new DataKey("DOUBLE_QUOTE_CLOSE", (Object)"&rdquo;");
    public static final DataKey<String> DOUBLE_QUOTE_OPEN = new DataKey("DOUBLE_QUOTE_OPEN", (Object)"&ldquo;");
    public static final DataKey<String> DOUBLE_QUOTE_UNMATCHED = new DataKey("DOUBLE_QUOTE_UNMATCHED", (Object)null);
    public static final DataKey<String> ELLIPSIS = new DataKey("ELLIPSIS", (Object)"&hellip;");
    public static final DataKey<String> ELLIPSIS_SPACED = new DataKey("ELLIPSIS_SPACED", (Object)"&hellip;");
    public static final DataKey<String> EM_DASH = new DataKey("EM_DASH", (Object)"&mdash;");
    public static final DataKey<String> EN_DASH = new DataKey("EN_DASH", (Object)"&ndash;");
    public static final DataKey<String> SINGLE_QUOTE_CLOSE = new DataKey("SINGLE_QUOTE_CLOSE", (Object)"&rsquo;");
    public static final DataKey<String> SINGLE_QUOTE_OPEN = new DataKey("SINGLE_QUOTE_OPEN", (Object)"&lsquo;");
    public static final DataKey<String> SINGLE_QUOTE_UNMATCHED = new DataKey("SINGLE_QUOTE_UNMATCHED", (Object)"&rsquo;");

    private TypographicExtension() {
    }

    public static Extension create() {
        return new TypographicExtension();
    }

    public void rendererOptions(MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public void extend(Parser.Builder parserBuilder) {
        if (((Boolean)ENABLE_QUOTES.getFrom((DataHolder)parserBuilder)).booleanValue()) {
            TypographicOptions options = new TypographicOptions((DataHolder)parserBuilder);
            parserBuilder.customDelimiterProcessor((DelimiterProcessor)new AngleQuoteDelimiterProcessor(options));
            parserBuilder.customDelimiterProcessor((DelimiterProcessor)new SingleQuoteDelimiterProcessor(options));
            parserBuilder.customDelimiterProcessor((DelimiterProcessor)new DoubleQuoteDelimiterProcessor(options));
        }
        if (((Boolean)ENABLE_SMARTS.getFrom((DataHolder)parserBuilder)).booleanValue()) {
            parserBuilder.customInlineParserExtensionFactory((InlineParserExtensionFactory)new SmartsInlineParser.Factory());
        }
    }

    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        if (rendererType.equals("HTML") || rendererType.equals("JIRA") || rendererType.equals("YOUTRACK")) {
            rendererBuilder.nodeRendererFactory((NodeRendererFactory)new TypographicNodeRenderer.Factory());
        }
    }
}

