/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;

public class LUDecompositor
implements MatrixDecompositor {
    @Override
    public Matrix[] decompose(Matrix matrix, Factory factory) {
        int i;
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows != columns");
        }
        Matrix lu = matrix.copy();
        for (int j = 0; j < lu.columns(); ++j) {
            int i2;
            Vector jcolumn = lu.getColumn(j);
            for (i = 0; i < lu.rows(); ++i) {
                int kmax = Math.min(i, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += lu.get(i, k) * jcolumn.get(k);
                }
                jcolumn.update(i, Vectors.asMinusFunction(s));
                lu.set(i, j, jcolumn.get(i));
            }
            int p = j;
            for (i2 = j + 1; i2 < lu.rows(); ++i2) {
                if (!(Math.abs(jcolumn.get(i2)) > Math.abs(jcolumn.get(p)))) continue;
                p = i2;
            }
            if (p != j) {
                for (int k = 0; k < lu.columns(); ++k) {
                    double t = lu.get(p, k);
                    lu.set(p, k, lu.get(j, k));
                    lu.set(j, k, t);
                }
            }
            if (!(j < lu.rows() & lu.get(j, j) != 0.0)) continue;
            for (i2 = j + 1; i2 < lu.rows(); ++i2) {
                lu.update(i2, j, Matrices.asDivFunction(lu.get(j, j)));
            }
        }
        Matrix l = factory.createMatrix(lu.rows(), lu.columns());
        for (int i3 = 0; i3 < l.rows(); ++i3) {
            for (int j = 0; j <= i3; ++j) {
                if (i3 > j) {
                    l.set(i3, j, lu.get(i3, j));
                    continue;
                }
                if (i3 != j) continue;
                l.set(i3, j, 1.0);
            }
        }
        Matrix u = factory.createMatrix(lu.columns(), lu.columns());
        for (i = 0; i < u.columns(); ++i) {
            for (int j = i; j < u.columns(); ++j) {
                if (i > j) continue;
                u.set(i, j, lu.get(i, j));
            }
        }
        return new Matrix[]{l, u};
    }
}

