/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.factory.Factory;
import org.la4j.linear.LinearSystem;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;

public class SweepSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;

    @Override
    public Vector solve(LinearSystem linearSystem, Factory factory) {
        int i;
        if (!this.suitableFor(linearSystem)) {
            throw new IllegalArgumentException();
        }
        Matrix a = linearSystem.coefficientsMatrix();
        Vector b = linearSystem.rightHandVector();
        Vector x = factory.createVector(linearSystem.variables());
        for (i = 0; i < linearSystem.variables() - 1; ++i) {
            int j;
            double maxItem = Math.abs(a.get(i, i));
            int maxIndex = i;
            for (j = i + 1; j < linearSystem.variables(); ++j) {
                if (!(Math.abs(a.get(j, i)) > maxItem)) continue;
                maxItem = Math.abs(a.get(j, i));
                maxIndex = j;
            }
            if (maxIndex != i) {
                for (j = 0; j < linearSystem.variables(); ++j) {
                    double t = a.get(i, j);
                    a.set(i, j, a.get(maxIndex, j));
                    a.set(maxIndex, j, t);
                }
                b.swap(i, maxIndex);
            }
            for (j = i + 1; j < linearSystem.variables(); ++j) {
                double c = a.get(j, i) / a.get(i, i);
                for (int k = i; k < a.columns(); ++k) {
                    a.update(j, k, Matrices.asMinusFunction(a.get(i, k) * c));
                }
                b.update(j, Vectors.asMinusFunction(b.get(i) * c));
            }
        }
        for (i = linearSystem.variables() - 1; i >= 0; --i) {
            double summand = 0.0;
            for (int j = i + 1; j < a.columns(); ++j) {
                summand += a.get(i, j) * x.get(j);
            }
            x.set(i, (b.get(i) - summand) / a.get(i, i));
        }
        return x;
    }

    @Override
    public boolean suitableFor(LinearSystem linearSystem) {
        return linearSystem.coefficientsMatrix().is(Matrices.TRIDIAGONAL_MATRIX);
    }
}

