/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.parallel.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openimaj.util.parallel.partition.Partitioner;

public class RangePartitioner<T>
implements Partitioner<T> {
    private final List<T> data;
    private final int numPartitions;
    private final int partitionSize;
    private int currentPartition = 0;
    private int remainder;

    public RangePartitioner(List<T> list, int numPartitions) {
        this.data = list;
        int ops = this.data.size();
        double div = (double)ops / (double)numPartitions;
        if (div >= 1.0) {
            this.partitionSize = (int)div;
            this.remainder = (int)((div - (double)this.partitionSize) * (double)numPartitions);
            this.numPartitions = numPartitions;
        } else {
            this.partitionSize = 1;
            this.remainder = 0;
            this.numPartitions = ops;
        }
    }

    public RangePartitioner(Collection<T> c, int numPartitions) {
        this((List<T>)new ArrayList<T>(c), numPartitions);
    }

    public RangePartitioner(T[] array, int numPartitions) {
        this(Arrays.asList(array), numPartitions);
    }

    public RangePartitioner(List<T> list) {
        this(list, Runtime.getRuntime().availableProcessors());
    }

    public RangePartitioner(Collection<T> c) {
        this((List<T>)new ArrayList<T>(c), Runtime.getRuntime().availableProcessors());
    }

    public RangePartitioner(T[] array) {
        this(Arrays.asList(array), Runtime.getRuntime().availableProcessors());
    }

    @Override
    public Iterator<Iterator<T>> getPartitions() {
        return new Iterator<Iterator<T>>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return RangePartitioner.this.currentPartition < RangePartitioner.this.numPartitions;
            }

            @Override
            public Iterator<T> next() {
                int start = this.offset + RangePartitioner.this.currentPartition * RangePartitioner.this.partitionSize;
                int stop = Math.min(this.offset + ++RangePartitioner.this.currentPartition * RangePartitioner.this.partitionSize, RangePartitioner.this.data.size());
                if (RangePartitioner.this.remainder > 0) {
                    ++stop;
                    RangePartitioner.this.remainder--;
                    ++this.offset;
                }
                return RangePartitioner.this.data.subList(start, stop).iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

