/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.set;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisjointSetForest<T>
implements Set<T> {
    private Map<T, Node> data;
    private TObjectIntHashMap<T> counts = new TObjectIntHashMap();

    public DisjointSetForest() {
        this.data = new HashMap<T, Node>();
    }

    public DisjointSetForest(int initialCapacity) {
        this.data = new HashMap<T, Node>(initialCapacity);
    }

    public T find(T x) {
        Node xNode = this.data.get(x);
        if (xNode == null) {
            return null;
        }
        if (x == xNode.parent) {
            return x;
        }
        xNode.parent = this.find(xNode.parent);
        return xNode.parent;
    }

    public T makeSet(T o) {
        if (this.data.containsKey(o)) {
            return null;
        }
        this.data.put(o, new Node(o, 0));
        this.counts.put(o, 1);
        return o;
    }

    public T union(T x, T y) {
        T yRoot;
        T xRoot = this.find(x);
        if (xRoot == (yRoot = this.find(y)) || xRoot == null || yRoot == null) {
            return null;
        }
        Node xNode = this.data.get(xRoot);
        Node yNode = this.data.get(yRoot);
        if (xNode.rank < yNode.rank) {
            xNode.parent = yRoot;
            this.counts.adjustValue(yRoot, this.counts.remove(xRoot));
            return yRoot;
        }
        if (xNode.rank > yNode.rank) {
            yNode.parent = xRoot;
            this.counts.adjustValue(xRoot, this.counts.remove(yRoot));
            return xRoot;
        }
        yNode.parent = xRoot;
        ++xNode.rank;
        this.counts.adjustValue(xRoot, this.counts.remove(yRoot));
        return xRoot;
    }

    public List<T> asList() {
        return new ArrayList<T>(this.data.keySet());
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<T> iterator;
            {
                this.iterator = DisjointSetForest.this.data.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not supported");
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.data.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.data.keySet().toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.makeSet(e) == e;
    }

    public T add(T elem, T repr) {
        if (repr == null) {
            return this.makeSet(elem);
        }
        if (this.data.containsKey(elem)) {
            return null;
        }
        if (!this.data.containsKey(repr)) {
            throw new IllegalArgumentException("Set containing representative not found");
        }
        this.add(elem);
        return this.union(repr, elem);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.data.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean changed = false;
        for (T c : collection) {
            if (this.makeSet(c) != c) continue;
            changed = true;
        }
        return changed;
    }

    public boolean addAll(Collection<? extends T> collection, boolean sameSet) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        if (!sameSet) {
            return this.addAll((Collection<? extends T>)collection);
        }
        T root = null;
        for (T c : collection) {
            if (root == null) {
                root = this.makeSet(c);
                continue;
            }
            this.add(c, root);
        }
        return root != null;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public int size(T o) {
        return this.counts.get(this.find(o));
    }

    public int numSets() {
        return this.counts.size();
    }

    public Set<Set<T>> getSubsets() {
        HashMap<T, HashSet<T>> set = new HashMap<T, HashSet<T>>();
        for (T t : this) {
            T repr = this.find(t);
            HashSet<T> reprSet = (HashSet<T>)set.get(repr);
            if (reprSet == null) {
                reprSet = new HashSet<T>();
                set.put(repr, reprSet);
            }
            reprSet.add(t);
        }
        return new HashSet<Set<T>>(set.values());
    }

    public static <T> DisjointSetForest<T> partition(List<T> values, Comparator<T> comparator) {
        DisjointSetForest<T> forest = new DisjointSetForest<T>(values.size());
        forest.addAll((Collection<T>)values);
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            T vi = values.get(i);
            for (int j = i + 1; j < size; ++j) {
                T vj = values.get(j);
                if (comparator.compare(vi, vj) != 0) continue;
                forest.union(vi, vj);
            }
        }
        return forest;
    }

    public static <T> Set<Set<T>> partitionSubsets(List<T> values, Comparator<T> comparator) {
        return DisjointSetForest.partition(values, comparator).getSubsets();
    }

    class Node {
        int rank;
        T parent;

        Node(T parent, int rank) {
            this.parent = parent;
            this.rank = rank;
        }
    }
}

