/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.unit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ngs.ngunits.UnconvertibleException;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.unit.AbstractUnit;
import org.ngs.ngunits.unit.AlternateUnit;
import org.ngs.ngunits.unit.AnnotatedUnit;
import org.ngs.ngunits.unit.BaseUnit;
import org.ngs.ngunits.unit.ProductUnit;
import org.ngs.ngunits.unit.TransformedUnit;
import org.ngs.ngunits.unit.UnitDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnitDelegate
implements UnitDelegate {
    public static final UnitDelegate INSTANCE = new DefaultUnitDelegate();
    private final AbstractUnit _one = new ProductUnit(this, new HashMap<Unit, Integer>());
    private final Map<String, Unit> _symbols = new HashMap<String, Unit>();

    @Override
    public AbstractUnit one() {
        return this._one;
    }

    @Override
    public synchronized void putSymbol(Unit unit, String string) {
        if (this._symbols.containsKey(string)) {
            Unit unit2 = this._symbols.get(string);
            if (!(unit instanceof AlternateUnit && unit2 instanceof AlternateUnit && ((AlternateUnit)unit).getParent().equals(((AlternateUnit)unit2).getParent()))) {
                new IllegalArgumentException("Symbol " + string + " is already associated to a different unit");
            }
        }
        this._symbols.put(string, unit);
    }

    public Set<Map.Entry<String, Unit>> getSymbols() {
        return Collections.unmodifiableSet(this._symbols.entrySet());
    }

    @Override
    public boolean compatible(Unit unit, Unit unit2) {
        try {
            return this.getBaseUnit(unit).equals(this.getBaseUnit(unit2));
        }
        catch (BaseUnitException baseUnitException) {
            return false;
        }
    }

    @Override
    public Unit annotate(Unit unit, String string) {
        return new AnnotatedUnit(this, unit, string);
    }

    @Override
    public Unit alternate(Unit unit, String string) {
        return new AlternateUnit(this, unit, string);
    }

    @Override
    public Unit transform(Unit unit, UnitConverter unitConverter) {
        if (unit instanceof TransformedUnit) {
            unitConverter = ((TransformedUnit)unit).toParent().concatenate(unitConverter);
            unit = ((TransformedUnit)unit).getParent();
        }
        if (unitConverter.isIdentity()) {
            return unit;
        }
        return new TransformedUnit(this, unit, unitConverter);
    }

    @Override
    public Unit multiply(Unit unit, Unit unit2) {
        return this.getProductInstance(this.productEntries(unit), this.productEntries(unit2));
    }

    @Override
    public Unit divide(Unit unit, Unit unit2) {
        HashMap<Unit, Integer> hashMap = new HashMap<Unit, Integer>();
        for (Map.Entry<Unit, Integer> entry : this.productEntries(unit2).entrySet()) {
            hashMap.put(entry.getKey(), -entry.getValue().intValue());
        }
        return this.getProductInstance(this.productEntries(unit), hashMap);
    }

    @Override
    public Unit pow(Unit unit, int n) {
        HashMap<Unit, Integer> hashMap = new HashMap<Unit, Integer>();
        Map<Unit, Integer> map = unit.getProductUnits();
        if (map != null) {
            for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue() * n);
            }
        } else {
            hashMap.put(unit, n);
        }
        return new ProductUnit(this, hashMap);
    }

    @Override
    public Unit root(Unit unit, int n) {
        Map<Unit, Integer> map = unit.getProductUnits();
        if (map != null) {
            HashMap<Unit, Integer> hashMap = new HashMap<Unit, Integer>();
            for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                if (entry.getValue() % n != 0) {
                    throw new ArithmeticException("fractional powers not supported");
                }
                hashMap.put(entry.getKey(), entry.getValue() / n);
            }
            return new ProductUnit(this, hashMap);
        }
        throw new ArithmeticException("fractional powers not supported");
    }

    @Override
    public UnitConverter getConverter(Unit unit, Unit unit2) throws UnconvertibleException {
        Unit unit3;
        if (unit.equals(unit2)) {
            return AbstractUnitConverter.IDENTITY;
        }
        Unit unit4 = unit.getSystemUnit();
        if (unit4.equals(unit3 = unit2.getSystemUnit())) {
            return ((AbstractUnit)unit2).toSystemUnit().inverse().concatenate(((AbstractUnit)unit).toSystemUnit());
        }
        try {
            Unit unit5 = this.getBaseUnit(unit);
            Unit unit6 = this.getBaseUnit(unit2);
            if (unit5.equals(unit6)) {
                UnitConverter unitConverter = ((AbstractUnit)unit).toSystemUnit().concatenate(this.getBaseConverter(unit4));
                UnitConverter unitConverter2 = ((AbstractUnit)unit2).toSystemUnit().concatenate(this.getBaseConverter(unit3));
                return unitConverter2.inverse().concatenate(unitConverter);
            }
        }
        catch (BaseUnitException baseUnitException) {
            // empty catch block
        }
        throw new UnconvertibleException("unable to convert", unit, unit2);
    }

    private Unit getBaseUnit(Unit unit) throws BaseUnitException {
        if (unit instanceof BaseUnit) {
            return unit;
        }
        if (unit instanceof AlternateUnit) {
            return this.getBaseUnit(((AlternateUnit)unit).getParent());
        }
        if (unit instanceof TransformedUnit) {
            return this.getBaseUnit(((TransformedUnit)unit).getParent());
        }
        if (unit instanceof ProductUnit) {
            Unit unit2 = this._one;
            for (Map.Entry<Unit, Integer> entry : unit.getProductUnits().entrySet()) {
                unit2 = unit2.multiply(this.getBaseUnit(entry.getKey()).pow(entry.getValue()));
            }
            return unit2;
        }
        throw new BaseUnitException();
    }

    private UnitConverter getBaseConverter(Unit unit) throws BaseUnitException {
        UnitConverter unitConverter = AbstractUnitConverter.IDENTITY;
        Map<Unit, Integer> map = unit.getProductUnits();
        if (map != null) {
            for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                UnitConverter unitConverter2 = this.getBaseConverter(entry.getKey());
                if (!unitConverter2.isLinear()) {
                    throw new BaseUnitException();
                }
                int n = entry.getValue();
                if (n < 0) {
                    n = -n;
                    unitConverter2 = unitConverter2.inverse();
                }
                for (int i = 0; i < n; ++i) {
                    unitConverter = unitConverter.concatenate(unitConverter2);
                }
            }
        }
        return unitConverter;
    }

    private Map<Unit, Integer> productEntries(Unit unit) {
        Map<Unit, Integer> map = unit.getProductUnits();
        if (map == null) {
            map = new HashMap<Unit, Integer>();
            map.put(unit, 1);
        }
        return map;
    }

    private Unit getProductInstance(Map<Unit, Integer> map, Map<Unit, Integer> map2) {
        HashMap<Unit, Integer> hashMap = new HashMap<Unit, Integer>();
        for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
            if (map2.containsKey(entry.getKey())) {
                int n = entry.getValue() + map2.get(entry.getKey());
                if (n == 0) continue;
                hashMap.put(entry.getKey(), n);
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Unit, Integer> entry : map2.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        if (hashMap.size() == 0) {
            return this._one;
        }
        if (hashMap.size() == 1 && (Integer)hashMap.values().iterator().next() == 1) {
            return (Unit)hashMap.keySet().iterator().next();
        }
        return new ProductUnit(this, hashMap);
    }

    private static class BaseUnitException
    extends Exception {
    }
}

