/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.extension.r.Configuration;
import org.nlogo.extension.r.ConsoleSync;
import org.nlogo.extension.r.HoldRengineX;
import org.nlogo.extension.r.JavaLibraryPath;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.RList;

public class Entry
extends DefaultClassManager {
    private static ExtensionManager shellwin;
    public static HoldRengineX rConn;
    public static ConsoleSync rSync;
    static String osName;
    static LibC libc;
    static WinLibC winLibc;
    static WinLib32 winLib32;
    Configuration configuration = null;
    static final SecurityManager exitPreventingSecurityManager;

    public void runOnce(ExtensionManager em) throws ExtensionException {
        this.configuration = Configuration.fromRExtensionProperties();
        Path rHome = this.validateRHome();
        try {
            this.loadJRILibraries(Entry.findJRIHomePath(this.configuration), rHome);
            REngine lastEngine = REngine.getLastEngine();
            if (System.getProperty("java.awt.headless", "false") == "true" || System.getProperty("org.nlogo.preferHeadless") == "true") {
                rConn = this.headlessREngine();
                this.addRLibPaths(rConn, false);
            } else if (lastEngine == null) {
                rConn = this.guiREngine();
                this.addRLibPaths(rConn, true);
                em.storeObject((Object)shellwin);
            } else {
                rConn = new HoldRengineX(lastEngine);
                shellwin = (ExtensionManager)em.retrieveObject();
            }
        }
        catch (UnsatisfiedLinkError ex) {
            throw new ExtensionException("Error loading JRI library (Error #03): \n" + ex);
        }
        catch (ExtensionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExtensionException("Error in R-Extension: Error in runOnce (Error #04): \n" + ex, ex);
        }
    }

    HoldRengineX headlessREngine() throws ExtensionException {
        try {
            Class<?> rengineClass = Class.forName("org.rosuda.REngine.JRI.JRIEngine");
            Class<?> callbacks_class = Class.forName("org.rosuda.REngine.REngineCallbacks");
            Method thisMethod = rengineClass.getDeclaredMethod("createEngine", new Class[0]);
            REngine rToStore = (REngine)thisMethod.invoke(rengineClass, new Object[0]);
            return new HoldRengineX(rToStore);
        }
        catch (Exception ex) {
            throw new ExtensionException("Error Initializing Headless R Extension (Error #04).\n", ex);
        }
    }

    HoldRengineX guiREngine() throws ExtensionException {
        try {
            ExtensionManager tc;
            Class<?> iashell_class = Class.forName("org.nlogo.extension.r.ShellWindow");
            Class[] partypes1 = new Class[]{ConsoleSync.class};
            Constructor<?> shellConstructor = iashell_class.getConstructor(partypes1);
            Object[] arglist1 = new Object[]{rSync};
            Object shell = shellConstructor.newInstance(arglist1);
            shellwin = tc = (ExtensionManager)shell;
            Class<?> rengineClass = Class.forName("org.rosuda.REngine.JRI.JRIEngine");
            Class<?> callbacks_class = Class.forName("org.rosuda.REngine.REngineCallbacks");
            Class[] partypes = new Class[]{String[].class, callbacks_class, Boolean.TYPE};
            Object[] arglist = new Object[]{new String[]{"--no-save"}, tc, true};
            Method thisMethod = rengineClass.getDeclaredMethod("createEngine", partypes);
            System.setSecurityManager(exitPreventingSecurityManager);
            REngine rToStore = (REngine)thisMethod.invoke(rengineClass, arglist);
            HoldRengineX holdRengineX = new HoldRengineX(rToStore);
            return holdRengineX;
        }
        catch (ExitTrappedException ex) {
            throw new ExtensionException("Could not load R libraries. (Error #06)\n", (Exception)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ExtensionException("Error initializing R extension. (Error #04)\n" + ex, (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtensionException("Error initializing R extension. (Error #04)\n" + ex, (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExtensionException("Error initializing R extension. (Error #04)\n" + ex, (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new ExtensionException("Error initializing R extension. (Error #04)\n" + ex, (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof ExitTrappedException) {
                throw new ExtensionException("Could not load R libraries. (Error #06)\n", (Exception)ex);
            }
            throw new ExtensionException("Error initializing R extension. (Error #04)\n" + ex + " " + ex.getCause(), (Exception)ex);
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    public Path validateRHome() throws ExtensionException {
        String rHomeEnv = System.getenv("R_HOME");
        if (rHomeEnv == null || rHomeEnv.isEmpty()) {
            if (!Files.exists(this.configuration.rHomePath(), new LinkOption[0])) {
                throw new ExtensionException("Could not find R Home. Please set R home in the environment or in user.properties in your r extension user directory: " + Configuration.userExtensionDir() + "  (Error #01)\n");
            }
            int setResult = 0;
            try {
                setResult = osName.startsWith("windows", 0) && winLibc != null ? winLibc._putenv_s("R_HOME", this.configuration.rHomePath().toAbsolutePath().toString()) : libc.setenv("R_HOME", this.configuration.rHomePath().toAbsolutePath().toString(), 1);
            }
            catch (Exception e) {
                setResult = -1;
            }
            if (setResult != 0) {
                throw new ExtensionException("Error setting R_HOME (#05).\n");
            }
        } else {
            Path rHomePath = Paths.get(System.getenv("R_HOME"), new String[0]);
            if (!Files.exists(rHomePath, new LinkOption[0])) {
                throw new ExtensionException("Could not find R at: " + System.getenv("R_HOME") + " . Please set R home in the environment or in user.properties (Error #01)\n");
            }
            this.configuration.setRHomePath(rHomePath);
        }
        return this.configuration.rHomePath();
    }

    static Path findJRIHomePath(Configuration configuration) throws ExtensionException {
        return configuration.jriHomePaths().stream().filter(path -> Files.exists(path.resolve("JRI.jar"), new LinkOption[0])).findFirst().orElseThrow(() -> new ExtensionException("Cannot locate rJava/JRI. Please check the location of your rJava installation and add a user.properties file in your r extension user directory: " + Configuration.userExtensionDir() + " (Error #02).\n"));
    }

    void loadJRILibraries(Path jriHomePath, Path rHome) throws ExtensionException {
        List<String> jarList = Arrays.asList("JRI.jar", "REngine.jar", "JRIEngine.jar");
        for (String jar : jarList) {
            try {
                JavaLibraryPath.addFile(jriHomePath.resolve(jar).toFile());
            }
            catch (IOException ex) {
                throw new ExtensionException("Error loading JRI Libraries (Error #04)\n", (Exception)ex);
            }
        }
        Path jriLib = jriHomePath;
        Path jri64Lib = jriHomePath.resolve("x64");
        Path jri32Lib = jriHomePath.resolve("i386");
        Optional<Path> rLibPath = Optional.empty();
        String dataModel = System.getProperty("sun.arch.data.model", "?");
        if (Files.exists(jri64Lib, new LinkOption[0]) && dataModel.contains("64")) {
            jriLib = jri64Lib;
            if (winLib32 != null) {
                rLibPath = Optional.of(rHome.resolve("bin/x64"));
            }
        } else if (Files.exists(jri32Lib, new LinkOption[0]) && dataModel.contains("32")) {
            jriLib = jri32Lib;
            if (winLib32 != null) {
                rLibPath = Optional.of(rHome.resolve("bin/i386"));
            }
        }
        try {
            try {
                JavaLibraryPath.addLibraryPath(jriLib.toFile());
            }
            catch (Exception ex) {
                throw new ExtensionException("Error Initializing R Extension: could not add JRI to library path (Error #04).\n", ex);
            }
            rLibPath.ifPresent(libPath -> winLib32.SetDllDirectoryA(libPath.toAbsolutePath().toString()));
        }
        catch (UnsatisfiedLinkError localUnsatisfiedLinkError) {
            throw new ExtensionException("Cannot load rJava libraries. Please check your rJava installation. (Error #03)\n" + localUnsatisfiedLinkError);
        }
    }

    private void addRLibPaths(HoldRengineX rConn, boolean guiPresent) {
        try {
            if (!this.configuration.rLibPaths().isEmpty()) {
                StringBuilder pathsString = new StringBuilder("c(");
                for (Path p : this.configuration.rLibPaths()) {
                    pathsString.append("'" + p.toString().replace("\\", "\\\\") + "',");
                }
                pathsString.deleteCharAt(pathsString.length() - 1);
                pathsString.append(")");
                rConn.execute(rConn.rConnection, ".libPaths(" + pathsString.toString() + ")", rConn.WorkingEnvironment, true);
            }
        }
        catch (Exception ex) {
            if (guiPresent) {
                JOptionPane.showMessageDialog(null, "Error while configuring r library paths: " + ex, "Error in R-Extension", 1);
            }
            System.err.println("Error while configuring r library paths, continuing: " + ex);
        }
    }

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("put", (Primitive)new Put());
        primManager.addPrimitive("putNamedList", (Primitive)new PutNamedList());
        primManager.addPrimitive("putList", (Primitive)new PutList());
        primManager.addPrimitive("putDataframe", (Primitive)new PutDataframe());
        primManager.addPrimitive("putAgent", (Primitive)new PutAgent());
        primManager.addPrimitive("putAgentDf", (Primitive)new PutAgentDataFrame());
        primManager.addPrimitive("eval", (Primitive)new Eval());
        primManager.addPrimitive("__evalDirect", (Primitive)new EvalDirect());
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("gc", (Primitive)new GC());
        primManager.addPrimitive("clear", (Primitive)new ClearWorkspace());
        primManager.addPrimitive("clearLocal", (Primitive)new ClearLocalWorkspace());
        primManager.addPrimitive("interactiveShell", (Primitive)new interactiveShell());
        primManager.addPrimitive("setPlotDevice", (Primitive)new SetPlotDevice());
        primManager.addPrimitive("stop", (Primitive)new Stop());
        primManager.addPrimitive("r-home", (Primitive)new DebugPrim(new RPath()));
        primManager.addPrimitive("jri-path", (Primitive)new DebugPrim(new JRIPath()));
    }

    public void unload() throws ExtensionException {
        if (!System.getProperty("java.awt.headless", "false").equals("true")) {
            try {
                System.gc();
                REXP returnVal = rConn.execute(Entry.rConn.rConnection, "rm(list=ls())", Entry.rConn.WorkingEnvironment, true);
                returnVal = null;
                Entry.rConn.rConnection.parseAndEval("rm(list=ls())");
                Entry.rConn.rConnection.parseAndEval("gc(reset=T)");
                System.gc();
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in unload: \n" + ex, ex);
            }
            try {
                if (shellwin.anyExtensionsLoaded()) {
                    shellwin.reset();
                }
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in making interactiveShell invisible: \n" + ex, ex);
            }
        }
    }

    static {
        rConn = null;
        rSync = new ConsoleSync();
        osName = System.getProperty("os.name").toLowerCase();
        libc = null;
        winLibc = null;
        winLib32 = null;
        try {
            if (osName.startsWith("windows", 0)) {
                String msvcrLibName = System.getProperty("org.nlogo.r.extension.msvcr.lib.name", "msvcr120");
                winLibc = (WinLibC)Native.loadLibrary((String)msvcrLibName, WinLibC.class);
                winLib32 = (WinLib32)Native.loadLibrary((String)"kernel32", WinLib32.class);
            } else {
                libc = (LibC)Native.loadLibrary((String)"c", LibC.class);
            }
        }
        catch (Throwable t) {
            System.err.println("Error loading native library: " + t.getMessage());
            t.printStackTrace();
        }
        exitPreventingSecurityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName().startsWith("exitVM")) {
                    throw new ExitTrappedException();
                }
            }
        };
    }

    public static class ClearLocalWorkspace
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                System.gc();
                REXP returnVal = rConn.execute(Entry.rConn.rConnection, "rm(list=ls())", Entry.rConn.WorkingEnvironment, true);
                returnVal = null;
                REXP returnVal2 = rConn.execute(Entry.rConn.rConnection, "gc(reset=T)", Entry.rConn.WorkingEnvironment, true);
                returnVal2 = null;
                System.gc();
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in ClearLocalWorkspace: \n" + ex, ex);
            }
        }
    }

    public static class ClearWorkspace
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                System.gc();
                REXP returnVal = rConn.execute(Entry.rConn.rConnection, "rm(list=ls())", Entry.rConn.WorkingEnvironment, true);
                returnVal = null;
                Entry.rConn.rConnection.parseAndEval("rm(list=ls())");
                Entry.rConn.rConnection.parseAndEval("gc(reset=T)");
                System.gc();
                rConn.sendEnvironmentToGlobal();
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in ClearWorkspace: \n" + ex, ex);
            }
        }
    }

    public static class GC
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                System.gc();
                rConn.execute(Entry.rConn.rConnection, "gc(reset=T)", Entry.rConn.WorkingEnvironment, true);
                Entry.rConn.rConnection.parseAndEval("gc(reset=T)");
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in GC: \n" + ex, ex);
            }
        }
    }

    public static class Get
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                REXP returnVal = rConn.execute(Entry.rConn.rConnection, args[0].getString(), Entry.rConn.WorkingEnvironment, true);
                Object retObj = rConn.returnObject(returnVal);
                returnVal = null;
                return retObj;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in Get. \n" + ex, ex);
            }
        }
    }

    public static class EvalDirect
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                String[] cmdArray = args[0].getString().split("\n");
                String c = null;
                for (int i = 0; i < cmdArray.length; ++i) {
                    c = cmdArray[i];
                    rSync.triggerNotification(c.trim());
                    c = null;
                }
                cmdArray = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in Eval: \n" + ex, ex);
            }
        }
    }

    public static class Eval
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                REXP returnVal = rConn.execute(Entry.rConn.rConnection, args[0].getString(), Entry.rConn.WorkingEnvironment, true);
                returnVal = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in Eval: \n" + ex, ex);
            }
        }
    }

    public static class Put
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                REXP val = rConn.resolveNLObject(args[1].get());
                Entry.rConn.rConnection.assign(args[0].getString(), val, Entry.rConn.WorkingEnvironment);
                val = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in Put. \n" + ex, ex);
            }
        }
    }

    public static class PutNamedList
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.WildcardType() | Syntax.RepeatableType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                Vector<String> names = new Vector<String>();
                RList rlist = new RList();
                for (int i = 0; i < args.length - 2; i += 2) {
                    names.add(args[i + 1].getString());
                    rlist.add((Object)rConn.resolveNLObject(args[i + 2].get()));
                }
                rlist.names = names;
                Entry.rConn.rConnection.assign(args[0].getString(), (REXP)new REXPGenericVector(rlist), Entry.rConn.WorkingEnvironment);
                names.clear();
                names = null;
                rlist = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in PutNamedList: \n" + ex, ex);
            }
        }
    }

    public static class PutList
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.WildcardType() | Syntax.RepeatableType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                Vector<String> names = new Vector<String>();
                RList rlist = new RList();
                for (int i = 0; i < args.length - 1; ++i) {
                    names.add(Integer.valueOf(i).toString());
                    rlist.add((Object)rConn.resolveNLObject(args[i + 1].get()));
                }
                rlist.names = names;
                Entry.rConn.rConnection.assign(args[0].getString(), (REXP)new REXPGenericVector(rlist), Entry.rConn.WorkingEnvironment);
                names.clear();
                names = null;
                rlist = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in PutVector: \n" + ex, ex);
            }
        }
    }

    public static class PutDataframe
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.WildcardType() | Syntax.RepeatableType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                Vector<String> names = new Vector<String>();
                RList rlist = new RList();
                for (int i = 0; i < args.length - 2; i += 2) {
                    names.add(args[i + 1].getString());
                    rlist.add((Object)rConn.resolveNLObject(args[i + 2].get()));
                }
                rlist.names = names;
                Entry.rConn.rConnection.assign(args[0].getString(), REXP.createDataFrame((RList)rlist), Entry.rConn.WorkingEnvironment);
                names.clear();
                names = null;
                rlist = null;
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in PutDataFrame: \n" + ex, ex);
            }
        }
    }

    public static class PutAgentDataFrame
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.AgentsetType() | Syntax.AgentType(), Syntax.StringType() | Syntax.RepeatableType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                rConn.AssignAgentsetorAgent(args, true);
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in PutAgentDf: \n" + ex, ex);
            }
        }
    }

    public static class PutAgent
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.AgentsetType() | Syntax.AgentType(), Syntax.StringType() | Syntax.RepeatableType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                rConn.AssignAgentsetorAgent(args, false);
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in PutAgent: \n" + ex, ex);
            }
        }
    }

    public static class interactiveShell
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                if (!System.getProperty("java.awt.headless", "false").equals("true") && !shellwin.anyExtensionsLoaded()) {
                    shellwin.finishFullCompilation();
                }
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in interactiveShell: \n" + ex, ex);
            }
        }
    }

    public static class SetPlotDevice
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                if (!System.getProperty("java.awt.headless", "false").equals("true")) {
                    shellwin.storeObject(null);
                }
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in setPlotDevice: \n" + ex, ex);
            }
        }
    }

    public static class Stop
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[0]);
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                if (System.getProperty("java.awt.headless", "false") == "true") {
                    Entry.rConn.rConnection.close();
                }
            }
            catch (Exception ex) {
                throw new ExtensionException("Error in R-Extension: Error in stop: \n" + ex);
            }
        }
    }

    public static class DebugPrim
    implements Reporter {
        final DebugSupplier supplier;

        public DebugPrim(DebugSupplier getValue) {
            this.supplier = getValue;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.StringType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return this.supplier.get();
        }
    }

    class JRIPath
    implements DebugSupplier {
        JRIPath() {
        }

        @Override
        public String get() throws ExtensionException {
            return Entry.findJRIHomePath(Entry.this.configuration).toString();
        }
    }

    class RPath
    implements DebugSupplier {
        RPath() {
        }

        @Override
        public String get() throws ExtensionException {
            return Entry.this.configuration.rHomePath().toString();
        }
    }

    @FunctionalInterface
    static interface DebugSupplier {
        public String get() throws ExtensionException;
    }

    private static class ExitTrappedException
    extends SecurityException {
        private ExitTrappedException() {
        }
    }

    public static interface WinLib32
    extends Library {
        public int SetDllDirectoryA(String var1);
    }

    public static interface WinLibC
    extends Library {
        public int _putenv_s(String var1, String var2);
    }

    public static interface LibC
    extends Library {
        public int setenv(String var1, String var2, int var3);
    }
}

