/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Argument;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;

public class HoldRengineX {
    public REngine rConnection = null;
    public REXP WorkingEnvironment = null;

    public HoldRengineX(REngine reng) {
        this.rConnection = reng;
        this.WorkingEnvironment = null;
        try {
            if (this.rConnection.supportsEnvironments()) {
                this.WorkingEnvironment = this.rConnection.newEnvironment(null, false);
                this.sendEnvironmentToGlobal();
            } else {
                new ExtensionException("Error in R-Extension: Please use a newer version of JRI/rJava.");
            }
        }
        catch (Exception ex) {
            new ExtensionException("Error in R-Extension: Error in environment creation: " + ex);
        }
    }

    public REXP execute(REngine engine, String cmd, REXP environment, boolean resolve) throws REngineException, REXPMismatchException, ExtensionException {
        REXP r = engine.parseAndEval("try(" + cmd + ",silent=TRUE)", environment, resolve);
        if (r.inherits("try-error")) {
            String error = r.asString();
            System.err.println("R Error: " + error);
            throw new ExtensionException(error);
        }
        return r;
    }

    public REXP resolveNLObject(Object obj) throws ExtensionException {
        block19: {
            if (obj instanceof LogoList) {
                LogoList logoli = (LogoList)obj;
                if (logoli.size() == 0) {
                    REXPNull ret = new REXPNull();
                    logoli = null;
                    return ret;
                }
                try {
                    if (logoli.get(0) instanceof String) {
                        String[] array = new String[logoli.size()];
                        int i = 0;
                        Iterator it = logoli.javaIterator();
                        while (it.hasNext()) {
                            array[i] = (String)it.next();
                            ++i;
                        }
                        REXPString ret = new REXPString(array);
                        array = null;
                        it = null;
                        logoli = null;
                        return ret;
                    }
                    if (logoli.get(0) instanceof Double) {
                        double[] array = new double[logoli.size()];
                        int i = 0;
                        Iterator it = logoli.javaIterator();
                        while (it.hasNext()) {
                            array[i] = (Double)it.next();
                            ++i;
                        }
                        REXPDouble ret = new REXPDouble(array);
                        array = null;
                        it = null;
                        logoli = null;
                        return ret;
                    }
                    if (logoli.get(0) instanceof Boolean) {
                        boolean[] array = new boolean[logoli.size()];
                        int i = 0;
                        Iterator it = logoli.javaIterator();
                        while (it.hasNext()) {
                            array[i] = (Boolean)it.next();
                            ++i;
                        }
                        REXPLogical ret = new REXPLogical(array);
                        array = null;
                        it = null;
                        logoli = null;
                        return ret;
                    }
                    if (logoli.get(0) instanceof LogoList) {
                        RList rlistxx = new RList();
                        for (int i = 0; i < logoli.size(); ++i) {
                            rlistxx.add((Object)this.resolveNLObject(logoli.get(i)));
                        }
                        REXPGenericVector ret = new REXPGenericVector(rlistxx);
                        rlistxx = null;
                        logoli = null;
                        return ret;
                    }
                    break block19;
                }
                catch (Exception ex) {
                    try {
                        REXP[] rexparray = new REXP[logoli.size()];
                        int i = 0;
                        Iterator it = logoli.javaIterator();
                        while (it.hasNext()) {
                            Object ob = it.next();
                            if (ob instanceof String) {
                                rexparray[i] = new REXPString((String)ob);
                            }
                            if (ob instanceof Boolean) {
                                rexparray[i] = new REXPLogical(((Boolean)ob).booleanValue());
                            }
                            if (ob instanceof Double) {
                                rexparray[i] = new REXPDouble(((Double)ob).doubleValue());
                            }
                            if (ob instanceof LogoList) {
                                rexparray[i] = this.resolveNLObject(ob);
                            }
                            ++i;
                            ob = null;
                        }
                        RList rlist = new RList(rexparray);
                        REXPGenericVector ret = new REXPGenericVector(rlist);
                        rlist = null;
                        rexparray = null;
                        it = null;
                        logoli = null;
                        return ret;
                    }
                    catch (Exception ex2) {
                        throw new ExtensionException("Error in R-Extension: Error in loopOverList:\n" + ex2);
                    }
                }
            }
            REXP ret = this.rConnection.wrap(obj);
            obj = null;
            return ret;
        }
        return null;
    }

    public void AssignAgentsetorAgent(Argument[] args, boolean as_dataframe) throws ExtensionException {
        try {
            Object ag = args[1].get();
            Vector<String> names = new Vector<String>();
            for (int i = 0; i < args.length - 2; ++i) {
                names.add(args[i + 2].getString());
            }
            RList rlist_base = new RList();
            if (ag instanceof AgentSet) {
                LogoListBuilder[] logoliarr = new LogoListBuilder[names.size()];
                for (int i = 0; i < logoliarr.length; ++i) {
                    logoliarr[i] = new LogoListBuilder();
                }
                AgentSet agentset = (AgentSet)ag;
                for (Agent agent : agentset) {
                    int varindex;
                    int j;
                    if (agent instanceof Turtle) {
                        for (j = 0; j < names.size(); ++j) {
                            varindex = agent.world().indexOfVariable(agent, ((String)names.get(j)).toUpperCase());
                            logoliarr[j].add(agent.getTurtleVariable(varindex));
                        }
                    } else if (agent instanceof Link) {
                        for (j = 0; j < names.size(); ++j) {
                            varindex = agent.world().indexOfVariable(agent, ((String)names.get(j)).toUpperCase());
                            logoliarr[j].add(agent.getLinkVariable(varindex));
                        }
                    } else if (agent instanceof Patch) {
                        for (j = 0; j < names.size(); ++j) {
                            varindex = agent.world().indexOfVariable(agent, ((String)names.get(j)).toUpperCase());
                            logoliarr[j].add(agent.getPatchVariable(varindex));
                        }
                    }
                    agent = null;
                }
                for (int i = 0; i < names.size(); ++i) {
                    rlist_base.add((Object)this.resolveNLObject(logoliarr[i].toLogoList()));
                }
                logoliarr = null;
                agentset = null;
                AgentIterator it = null;
            } else if (ag instanceof Agent) {
                Agent agent = (Agent)ag;
                for (int j = 0; j < names.size(); ++j) {
                    RList rlist = new RList();
                    int varindex = agent.world().indexOfVariable(agent, ((String)names.get(j)).toUpperCase());
                    if (agent instanceof Turtle) {
                        rlist.add((Object)this.resolveNLObject(agent.getTurtleVariable(varindex)));
                    }
                    if (agent instanceof Link) {
                        rlist.add((Object)this.resolveNLObject(agent.getLinkVariable(varindex)));
                    }
                    if (agent instanceof Patch) {
                        rlist.add((Object)this.resolveNLObject(agent.getPatchVariable(varindex)));
                    }
                    rlist_base.add((Object)new REXPGenericVector(rlist));
                    rlist = null;
                }
                agent = null;
            }
            rlist_base.names = names;
            if (as_dataframe) {
                this.rConnection.assign(args[0].getString(), REXP.createDataFrame((RList)rlist_base), this.WorkingEnvironment);
            } else {
                this.rConnection.assign(args[0].getString(), (REXP)new REXPGenericVector(rlist_base), this.WorkingEnvironment);
            }
            rlist_base = null;
            ag = null;
            names.clear();
            names = null;
        }
        catch (Exception ex) {
            throw new ExtensionException("Error in AssignAgentsetorAgent: \n" + ex);
        }
    }

    private Object resolveListAndVector(REXP result) throws REXPMismatchException {
        if (result.isNumeric()) {
            double[] dbarray = result.asDoubles();
            LogoListBuilder llist = new LogoListBuilder();
            for (int i = 0; i < dbarray.length; ++i) {
                llist.add((Object)dbarray[i]);
            }
            dbarray = null;
            result = null;
            return llist.toLogoList();
        }
        if (result.isInteger()) {
            int[] intarray = result.asIntegers();
            LogoListBuilder llist = new LogoListBuilder();
            for (int i = 0; i < intarray.length; ++i) {
                llist.add((Object)new Double(Integer.valueOf(intarray[i]).doubleValue()));
            }
            intarray = null;
            result = null;
            return llist.toLogoList();
        }
        if (result.isString()) {
            String[] strarray = result.asStrings();
            LogoListBuilder llist = new LogoListBuilder();
            for (int i = 0; i < strarray.length; ++i) {
                llist.add((Object)strarray[i]);
            }
            strarray = null;
            result = null;
            return llist.toLogoList();
        }
        if (result.isLogical()) {
            int[] boolarray = result.asIntegers();
            LogoListBuilder llist = new LogoListBuilder();
            for (int i = 0; i < boolarray.length; ++i) {
                if (boolarray[i] == 1) {
                    llist.add((Object)true);
                    continue;
                }
                llist.add((Object)false);
            }
            boolarray = null;
            result = null;
            return llist.toLogoList();
        }
        result = null;
        return null;
    }

    public Object returnObject(REXP result) throws REXPMismatchException {
        if (result.length() == 1) {
            if (result.isString() || result.isNull()) {
                return result.asString();
            }
            if (result.isNumeric()) {
                return result.asDouble();
            }
            if (result.isInteger()) {
                return result.asInteger();
            }
            if (result.isLogical()) {
                if (result.asInteger() == 1) {
                    return true;
                }
                return false;
            }
        }
        if (result.isList()) {
            LogoListBuilder llist = new LogoListBuilder();
            ListIterator li = result.asList().listIterator();
            while (li.hasNext()) {
                REXP val = (REXP)li.next();
                llist.add(this.returnObject(val));
                val = null;
            }
            li = null;
            result = null;
            return llist.toLogoList();
        }
        if (result.isVector()) {
            return this.resolveListAndVector(result);
        }
        return null;
    }

    public void sendEnvironmentToGlobal() throws ExtensionException {
        try {
            this.execute(this.rConnection, "nl.env <<- environment()", this.WorkingEnvironment, true);
        }
        catch (Exception ex) {
            throw new ExtensionException("Error in R-Extension: An error occured while sending local environment to global: " + ex);
        }
    }
}

