/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ximgproc;

import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.ximgproc.GraphSegmentation;
import org.opencv.ximgproc.SelectiveSearchSegmentationStrategy;

public class SelectiveSearchSegmentation
extends Algorithm {
    protected SelectiveSearchSegmentation(long addr) {
        super(addr);
    }

    public static SelectiveSearchSegmentation __fromPtr__(long addr) {
        return new SelectiveSearchSegmentation(addr);
    }

    public void addGraphSegmentation(GraphSegmentation g) {
        SelectiveSearchSegmentation.addGraphSegmentation_0(this.nativeObj, g.getNativeObjAddr());
    }

    public void addImage(Mat img) {
        SelectiveSearchSegmentation.addImage_0(this.nativeObj, img.nativeObj);
    }

    public void addStrategy(SelectiveSearchSegmentationStrategy s) {
        SelectiveSearchSegmentation.addStrategy_0(this.nativeObj, s.getNativeObjAddr());
    }

    public void clearGraphSegmentations() {
        SelectiveSearchSegmentation.clearGraphSegmentations_0(this.nativeObj);
    }

    public void clearImages() {
        SelectiveSearchSegmentation.clearImages_0(this.nativeObj);
    }

    public void clearStrategies() {
        SelectiveSearchSegmentation.clearStrategies_0(this.nativeObj);
    }

    public void process(MatOfRect rects) {
        MatOfRect rects_mat = rects;
        SelectiveSearchSegmentation.process_0(this.nativeObj, rects_mat.nativeObj);
    }

    public void setBaseImage(Mat img) {
        SelectiveSearchSegmentation.setBaseImage_0(this.nativeObj, img.nativeObj);
    }

    public void switchToSelectiveSearchFast(int base_k, int inc_k, float sigma) {
        SelectiveSearchSegmentation.switchToSelectiveSearchFast_0(this.nativeObj, base_k, inc_k, sigma);
    }

    public void switchToSelectiveSearchFast(int base_k, int inc_k) {
        SelectiveSearchSegmentation.switchToSelectiveSearchFast_1(this.nativeObj, base_k, inc_k);
    }

    public void switchToSelectiveSearchFast(int base_k) {
        SelectiveSearchSegmentation.switchToSelectiveSearchFast_2(this.nativeObj, base_k);
    }

    public void switchToSelectiveSearchFast() {
        SelectiveSearchSegmentation.switchToSelectiveSearchFast_3(this.nativeObj);
    }

    public void switchToSelectiveSearchQuality(int base_k, int inc_k, float sigma) {
        SelectiveSearchSegmentation.switchToSelectiveSearchQuality_0(this.nativeObj, base_k, inc_k, sigma);
    }

    public void switchToSelectiveSearchQuality(int base_k, int inc_k) {
        SelectiveSearchSegmentation.switchToSelectiveSearchQuality_1(this.nativeObj, base_k, inc_k);
    }

    public void switchToSelectiveSearchQuality(int base_k) {
        SelectiveSearchSegmentation.switchToSelectiveSearchQuality_2(this.nativeObj, base_k);
    }

    public void switchToSelectiveSearchQuality() {
        SelectiveSearchSegmentation.switchToSelectiveSearchQuality_3(this.nativeObj);
    }

    public void switchToSingleStrategy(int k, float sigma) {
        SelectiveSearchSegmentation.switchToSingleStrategy_0(this.nativeObj, k, sigma);
    }

    public void switchToSingleStrategy(int k) {
        SelectiveSearchSegmentation.switchToSingleStrategy_1(this.nativeObj, k);
    }

    public void switchToSingleStrategy() {
        SelectiveSearchSegmentation.switchToSingleStrategy_2(this.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        SelectiveSearchSegmentation.delete(this.nativeObj);
    }

    private static native void addGraphSegmentation_0(long var0, long var2);

    private static native void addImage_0(long var0, long var2);

    private static native void addStrategy_0(long var0, long var2);

    private static native void clearGraphSegmentations_0(long var0);

    private static native void clearImages_0(long var0);

    private static native void clearStrategies_0(long var0);

    private static native void process_0(long var0, long var2);

    private static native void setBaseImage_0(long var0, long var2);

    private static native void switchToSelectiveSearchFast_0(long var0, int var2, int var3, float var4);

    private static native void switchToSelectiveSearchFast_1(long var0, int var2, int var3);

    private static native void switchToSelectiveSearchFast_2(long var0, int var2);

    private static native void switchToSelectiveSearchFast_3(long var0);

    private static native void switchToSelectiveSearchQuality_0(long var0, int var2, int var3, float var4);

    private static native void switchToSelectiveSearchQuality_1(long var0, int var2, int var3);

    private static native void switchToSelectiveSearchQuality_2(long var0, int var2);

    private static native void switchToSelectiveSearchQuality_3(long var0);

    private static native void switchToSingleStrategy_0(long var0, int var2, float var3);

    private static native void switchToSingleStrategy_1(long var0, int var2);

    private static native void switchToSingleStrategy_2(long var0);

    private static native void delete(long var0);
}

