/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.math.geometry.shape.Rectangle;

public abstract class FontRenderer<T, Q extends FontStyle<T>> {
    public abstract void renderText(ImageRenderer<T, ?> var1, String var2, int var3, int var4, Q var5);

    public abstract Rectangle getSize(String var1, Q var2);

    public Rectangle getBounds(String string, int x, int y, Q sty) {
        Rectangle rect = this.getSize(string, sty);
        if (((FontStyle)sty).getHorizontalAlignment() != FontStyle.HorizontalAlignment.HORIZONTAL_LEFT) {
            float len = (float)rect.getWidth();
            x = ((FontStyle)sty).getHorizontalAlignment() == FontStyle.HorizontalAlignment.HORIZONTAL_CENTER ? (int)((float)x - len / 2.0f) : (int)((float)x - len);
        }
        if (((FontStyle)sty).getVerticalAlignment() != FontStyle.VerticalAlignment.VERTICAL_TOP) {
            switch (((FontStyle)sty).getVerticalAlignment()) {
                case VERTICAL_BOTTOM: {
                    y = (int)((double)y - rect.getHeight());
                    break;
                }
                case VERTICAL_HALF: {
                    y = (int)((double)y - rect.getHeight() / 2.0);
                    break;
                }
            }
        }
        rect.x = x;
        rect.y = y;
        return rect;
    }

    public static <T> void renderText(ImageRenderer<T, ?> renderer, AttributedString text, int x, int y) {
        Character c;
        AttributedCharacterIterator iterator = text.getIterator();
        while ((c = Character.valueOf(iterator.current())).charValue() != '\uffff') {
            FontStyle<T> sty = FontStyle.parseAttributes(iterator.getAttributes(), renderer);
            FontRenderer<T, FontStyle<T>> fontRenderer = sty.getRenderer(renderer);
            Rectangle rect = fontRenderer.getSize(c.toString(), sty);
            fontRenderer.renderText(renderer, c.toString(), x, y, sty);
            x = (int)((float)x + rect.width);
            y = (int)((float)y + rect.height);
            iterator.next();
        }
    }

    public static <T> Rectangle getBounds(AttributedString text, ImageRenderer<T, ?> imageRenderer) {
        Character c;
        AttributedCharacterIterator iterator = text.getIterator();
        int x = 0;
        int y = 0;
        while ((c = Character.valueOf(iterator.current())).charValue() != '\uffff') {
            FontStyle<T> sty = FontStyle.parseAttributes(iterator.getAttributes(), imageRenderer);
            FontRenderer<T, FontStyle<T>> renderer = sty.getRenderer(imageRenderer);
            Rectangle rect = renderer.getSize(c.toString(), sty);
            x = (int)((float)x + rect.width);
            y = (int)((float)y + rect.height);
            iterator.next();
        }
        return new Rectangle(0.0f, 0.0f, (float)x, (float)y);
    }
}

