/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSuite
implements Serializable,
Cloneable {
    @Deprecated
    public static final String JAVADOC = "javadoc";
    public static final String JDK5_ANNOTATION_TYPE = "JDK5";
    public static final String JAVADOC_ANNOTATION_TYPE = "javadoc";
    private String m_test;
    private String m_name = "Command line suite";
    private Integer m_verbose = new Integer(1);
    private boolean m_parallel = false;
    private Boolean m_isJUnit = Boolean.FALSE;
    private int m_threadCount = 5;
    private String m_annotations = "JDK5";
    private List<XmlPackage> m_xmlPackages = new ArrayList<XmlPackage>();
    private String m_expression = null;
    private List<XmlMethodSelector> m_methodSelectors = new ArrayList<XmlMethodSelector>();
    private List<XmlTest> m_tests = new ArrayList<XmlTest>();
    private Map<String, String> m_parameters = new HashMap<String, String>();
    private String m_fileName;

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public boolean isParallel() {
        return this.m_parallel;
    }

    public void setParallel(boolean parallel) {
        this.m_parallel = parallel;
    }

    public Integer getVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = methodSelectors;
    }

    public void setBeanShellExpression(String expression) {
        this.m_expression = expression;
    }

    @Deprecated
    public String getExpression() {
        return this.m_expression;
    }

    public String getBeanShellExpression() {
        return this.m_expression;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.m_parameters.keySet()) {
            result.put(key, this.m_parameters.get(key));
        }
        for (XmlTest test : this.getTests()) {
            Map<String, String> tp = test.getParameters();
            for (String key : tp.keySet()) {
                result.put(key, tp.get(key));
            }
        }
        return result;
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public String getAnnotations() {
        return this.m_annotations;
    }

    public void setAnnotations(String annotations) {
        this.m_annotations = annotations;
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = packages;
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public String toXml() {
        XMLStringBuffer xsb = new XMLStringBuffer("");
        xsb.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        p.setProperty("verbose", this.getVerbose().toString());
        p.setProperty("parallel", "" + this.isParallel());
        p.setProperty("thread-count", "" + this.getThreadCount());
        p.setProperty("annotations", this.getAnnotations());
        xsb.push("suite", p);
        for (String paramName : this.m_parameters.keySet()) {
            Properties paramProps = new Properties();
            paramProps.setProperty("name", paramName);
            paramProps.setProperty("value", this.m_parameters.get(paramName));
            xsb.addEmptyElement("parameter", paramProps);
        }
        for (XmlTest test : this.getTests()) {
            xsb.getStringBuffer().append(test.toXml("  "));
        }
        if (null != this.getXmlPackages() && !this.getXmlPackages().isEmpty()) {
            xsb.push("packages");
            for (XmlPackage pack : this.getXmlPackages()) {
                xsb.getStringBuffer().append(pack.toXml("  "));
            }
            xsb.pop("packages");
        }
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector selector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(selector.toXml("  "));
            }
            xsb.pop("method-selectors");
        }
        xsb.pop("suite");
        return xsb.toXML();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Suite: \"" + this.m_name + "\" ");
        for (XmlTest t : this.m_tests) {
            result.append("  " + t.toString()).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    private static void ppp(String s) {
        System.out.println("[XmlSuite] " + s);
    }

    public Object clone() {
        XmlSuite result = new XmlSuite();
        result.setName(this.getName());
        result.setAnnotations(this.getAnnotations());
        result.setParallel(this.isParallel());
        result.setThreadCount(this.getThreadCount());
        result.setParameters(this.getAllParameters());
        result.setVerbose(this.getVerbose());
        result.setXmlPackages(this.getXmlPackages());
        result.setBeanShellExpression(this.getExpression());
        result.setMethodSelectors(this.getMethodSelectors());
        return result;
    }
}

