/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class FloatCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    @Override
    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String.class, new Converter(){

            @Override
            public Object convert(Object o) {
                if (((String)o).length() == 0) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(Float.parseFloat((String)o));
            }
        });
        CNV.put(Object.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return ((Converter)CNV.get(String.class)).convert(String.valueOf(o));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((BigDecimal)o).floatValue());
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((BigInteger)o).floatValue());
            }
        });
        CNV.put(Float.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Integer.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((Integer)o).floatValue());
            }
        });
        CNV.put(Double.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((Double)o).floatValue());
            }
        });
        CNV.put(Long.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((Long)o).floatValue());
            }
        });
        CNV.put(Short.class, new Converter(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(((Short)o).floatValue());
            }
        });
        CNV.put(Boolean.class, new Converter(){

            @Override
            public Float convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
    }
}

