/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.Map;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;

public abstract class BaseVariableResolverFactory
implements VariableResolverFactory {
    protected Map<String, VariableResolver> variableResolvers;
    protected VariableResolverFactory nextFactory;

    @Override
    public VariableResolverFactory getNextFactory() {
        return this.nextFactory;
    }

    @Override
    public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
        this.nextFactory = resolverFactory;
        return this.nextFactory;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.isResolveable(name)) {
            if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
                return this.variableResolvers.get(name);
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
        }
        return null;
    }

    public boolean isNextResolveable(String name) {
        return this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    public void appendFactory(VariableResolverFactory resolverFactory) {
        VariableResolverFactory vrf = this.nextFactory;
        if (vrf == null) {
            this.nextFactory = resolverFactory;
        } else {
            while (vrf.getNextFactory() != null) {
                vrf = vrf.getNextFactory();
            }
            vrf.setNextFactory(this.nextFactory);
        }
    }

    public void insertFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            resolverFactory.setNextFactory(resolverFactory);
            this.nextFactory = resolverFactory;
        }
    }
}

