/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Oct 1994.
 */

/* display.c - output functions for X interface */

#include "scrab.h"
#include "globals.h"

void ShowTiles()
{
	char lname[2];
	int ac,dn;
	
	for (dn=0; dn<BOARDSIZE; dn++)
		for (ac=0; ac<BOARDSIZE; ac++)
			if (cboard[ac][dn] != ' ')
			{
				sprintf(lname,"%c",cboard[ac][dn]);
				XtVaSetValues(sq[curr_player][ac][dn],XtNlabel,lname,
					SETBG(TILECOL),NULL);
				is_perm[ac][dn]=True;
			}
			else
			{
				XtVaSetValues(sq[curr_player][ac][dn],XtNlabel," ",
						SETBG((char *)colours[sq_col[ac][dn]]),NULL);
				is_perm[ac][dn]=False;
			}
}

void ShowBoard(Boolean leavecolours)
{
	/* display board for everyone */
	int ac,dn,i;
	char lname[2];

	for (i=0; i<num_players; i++)
		for (dn=0; dn<BOARDSIZE; dn++)
			for (ac=0; ac<BOARDSIZE; ac++)
				if (board[ac][dn] != ' ')
				{
					sprintf(lname,"%c",board[ac][dn]);
					XtVaSetValues(sq[i][ac][dn],XtNlabel,lname,NULL);
					if (leavecolours && (!is_perm[ac][dn]))
						XtVaSetValues(sq[i][ac][dn],SETBG(BRIGHTCOL),NULL);
					else
						XtVaSetValues(sq[i][ac][dn],SETBG(TILECOL),NULL);
				}
}

void ShowBar(int ply)
{
	/* display letters in bar for player number ply */
	int i;
	char ch,lett[3];

	for (i=0; i<LONGBAR; i++)
	{
		if ((i>2) && (i<10))
		{
			/* in central part of bar */
			ch=player[ply].bar[i-3];
			bar[ply][i]=ch;
			sprintf(lett,"%c",ch);
			if (ch==' ')
				XtVaSetValues(br[ply][i],SETBG(BARCOL),XtNlabel,lett,NULL);
			else
				XtVaSetValues(br[ply][i],SETBG(TILECOL),XtNlabel,lett,NULL);
		}
		else
		{
			XtVaSetValues(br[ply][i],SETBG(BARCOL),XtNlabel," ",NULL);
			bar[ply][i]=' ';
		}
	}
}

void ShowScores()
{
	int i,rep;
	char scoretext[256]="",scstring[8];

	for (i=0; i<num_players; i++)
	{
		if (i==curr_player)
			strcat(scoretext,">");
		else
			strcat(scoretext," ");
		strcat(scoretext,player[i].name);
		sprintf(scstring,"%d",player[i].score);
		for (rep=0; rep<(int)(16-strlen(player[i].name)-strlen(scstring)); rep++)
			strcat(scoretext,".");
		strcat(scoretext,scstring);
		if (i<num_players-1)
			strcat(scoretext,"\n");
	}	
	
	for (i=0; i<num_players; i++)
		XtVaSetValues(scorebox[i],XtNlabel,scoretext,NULL);
}

void TilesLeft()
{
	char tileltext[256];
	int i;

	sprintf(tileltext,"%s%d",PROMPT[TILES_LEFT],bagptr+1);

	for (i=0; i<num_players; i++)
		XtVaSetValues(tilesleft[i],XtNlabel,tileltext,NULL);
}

/* for the timer */
void Click()
{
	if (!finished_go)
	{
        if (pauseflag==1) comp+=10;
        if (comp==10000-10*50)
        	XBell(dpy[curr_player],2*bell_level-100);
        if (comp==10000-10*25)
        	XBell(dpy[curr_player],(3*bell_level)/2-100);
        if (comp==10000/2)
        	XBell(dpy[curr_player],bell_level-100);
        if (comp>10000)
		{
			char mess[256];

                        XtVaSetValues(pauseButton[curr_player],
                                 XtNmappedWhenManaged,False,NULL);
			
			XBell(dpy[curr_player],2*bell_level-100);
			sprintf(mess,PROMPT[OUT_TIME_ALL],player[curr_player].name);
			Message(curr_player,PROMPT[OUT_TIME],mess);
			Deselect(curr_player);

			RemoveFromBoard();
			ShowTiles();
			ShowBar(curr_player);
			num_passed=0;
			if (waiting_for_change)
			{
				XtPopdown(changeshell);
				XtDestroyWidget(changeshell);
				waiting_for_change=False;
			}
			if (waiting_for_blank)
			{
				XtPopdown(blankshell);
				XtDestroyWidget(blankshell);
				waiting_for_blank=False;
			}
			GotoNextPlayer();
		}
		else
		{
	        XtVaSetValues(timeleft[curr_player],XtNpercentageCompleted,
	        	comp,NULL);
	        XtAppAddTimeOut(app_context,55*time_limit,Click,
	        	timeleft[curr_player]);
		}
	}
}


void MessageAll(char *mess)
{
	/* send same message to everyone */
	int i;

	for (i=0; i<num_players; i++)
		XtVaSetValues(message[i],XtNlabel,mess,NULL);
}

void Message(int ply,char *mess1, char *mess2)
{
	/* send mess1 to ply, and mess2 to everyone else */
	int i;
	
	for (i=0; i<num_players; i++)
		if (i==ply)
			XtVaSetValues(message[i],XtNlabel,mess1,NULL);
		else
			XtVaSetValues(message[i],XtNlabel,mess2,NULL);
}

void MessageOne(int ply,char *mess)
{
	/* send mess only to ply */
	XtVaSetValues(message[ply],XtNlabel,mess,NULL);
}

void EndDelay()
{
	waiting=False;
}

void Wait(int delay)
{
	/* wait for specified time, processing X events */
	waiting=True;
	XtAppAddTimeOut(XtWidgetToApplicationContext(message[0]),delay,
		EndDelay,message[0]);
	while (waiting==True)
		ProcessEvent();
}

void ProcessEvent()
{
	/* processes any pending events */
	XtInputMask msk=XtIMAll;
	if (XtAppPending(app_context)!=0)
		XtAppProcessEvent(app_context,msk);	
}

void UpdateComp(int perc)
{
	/* on computer's move, update Xc widget with % completed */
  /*  printf("Update value = %i\n",perc);*/
	XcBGUpdateValue(compw[curr_player],&perc);
}
