/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Nov 1994.
 */

/* main.c - the main function */

#include "scrab.h"
#include "globals.h"
#include "config.h"

#include "xscrabble.xpm"
#include "slate_green.xpm"

/* option types and default values */

char app_def_file[256]="XScrabble";

int pauseflag = 2;

int bagptr, NUMLETTERS, NUMBLANKS;

int letterscore[NUMCHAR_MAX];
int freq[NUMCHAR_MAX];

char letterchar[NUMLETTERS_MAX];
char blanktiles[NUMBLANKS_MAX];

char bag[BAGSIZE_MAX];
char PROMPT[NUMPROMPTS][256];

static XtResource resources[] =
{
	{"load","Load",XtRBoolean,sizeof(Boolean),XtOffsetOf(struct AppData,load),
		XtRImmediate,(XtPointer) False},
	{"version","Version",XtRInt,sizeof(int),XtOffsetOf(struct AppData,version),
		XtRImmediate,(XtPointer) 0},
	{"players","Players",XtRInt,sizeof(int),XtOffsetOf(struct AppData,players),
		XtRImmediate,(XtPointer) 1},
	{"bell","Bell",XtRInt,sizeof(int),XtOffsetOf(struct AppData,bell),
		XtRImmediate,(XtPointer) 100},
	{"time","Time",XtRInt,sizeof(int),XtOffsetOf(struct AppData,timelim),
		XtRImmediate,(XtPointer) 0},
	{"t1","T1",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[0]),
		XtRImmediate,(XtPointer) 0},
	{"t2","T2",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[1]),
		XtRImmediate,(XtPointer) 0},
	{"t3","T3",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[2]),
		XtRImmediate,(XtPointer) 0},
	{"t4","T4",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[3]),
		XtRImmediate,(XtPointer) 0},
	{"d1","D1",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[0]),
		XtRImmediate,":0.0"},
	{"d2","D2",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[1]),
		XtRImmediate,":0.0"},
	{"d3","D3",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[2]),
		XtRImmediate,":0.0"},
	{"d4","D4",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[3]),
		XtRImmediate,":0.0"},
	{"n1","N1",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[0]),
		XtRImmediate,""},
	{"n2","N2",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[1]),
		XtRImmediate,""},
	{"n3","N3",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[2]),
		XtRImmediate,""},
	{"n4","N4",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[3]),
		XtRImmediate,""},
	{"dictfile","Dictfile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,dictfile),XtRImmediate, DICT_FILE},
	{"scorefile","Scorefile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,scorefile),XtRImmediate, SCORE_FILE},
	{"rulesfile","Rulesfile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,rulesfile),XtRImmediate, RULES_FILE}
};

/* resource options */
static XrmOptionDescRec options[] =
{
        {"-load",     	 "*load",        XrmoptionNoArg, "True" },
        {"-players",     "*players",     XrmoptionSepArg, NULL  },
        {"-bell",     	 "*bell",        XrmoptionSepArg, NULL  },
        {"-time",     	 "*time",        XrmoptionSepArg, NULL  },
        {"-d1",      	 "*d1",          XrmoptionSepArg, NULL  },
        {"-d2",      	 "*d2",          XrmoptionSepArg, NULL  },
        {"-d3",      	 "*d3",          XrmoptionSepArg, NULL  },
        {"-d4",      	 "*d4",          XrmoptionSepArg, NULL  },
        {"-n1",      	 "*n1",          XrmoptionSepArg, NULL  },
        {"-n2",      	 "*n2",          XrmoptionSepArg, NULL  },
        {"-n3",      	 "*n3",          XrmoptionSepArg, NULL  },
        {"-n4",      	 "*n4",          XrmoptionSepArg, NULL  },
        {"-t1",      	 "*t1",          XrmoptionSepArg, NULL  },
        {"-t2",      	 "*t2",          XrmoptionSepArg, NULL  },
        {"-t3",      	 "*t3",          XrmoptionSepArg, NULL  },
        {"-t4",      	 "*t4",          XrmoptionSepArg, NULL  },
        {"-dictfile",  	 "*dictfile",    XrmoptionSepArg, NULL  },
        {"-scorefile", 	 "*scorefile",   XrmoptionSepArg, NULL  },
        {"-rulesfile", 	 "*rulesfile",   XrmoptionSepArg, NULL  }
};

void main(int argc, char **argv)
{
	char defaultname[MAXPLAYERS][NAMELEN];
        char mess[256];
	int i,j,ind;
	Widget topLevel,prompts;
	Boolean any_comp=False;
        String prompts_str;

        for(i=0;i<argc-1;i++) 
        {
            if(strncmp(argv[i],"-language",5)==0) 
               {
               strcat(app_def_file,"_");
               strcat(app_def_file,argv[i+1]);
	       }
	}

	topLevel = XtVaAppInitialize(&app_context,app_def_file,options,XtNumber(options),
		&argc,argv,NULL,NULL);

	XtVaGetApplicationResources(topLevel,&app_data,resources,
		XtNumber(resources),NULL);

        prompts  = XtVaCreateManagedWidget("prompts", labelWidgetClass, topLevel, NULL);
        XtVaSetValues(prompts,XtNmappedWhenManaged,False,NULL);
        XtVaSetValues(prompts,XtNwidth,1,NULL);
        XtVaGetValues(prompts,XtNlabel,&prompts_str,NULL);

        i=0; j=0;

        for (ind=0; ind<strlen(prompts_str); ind++)
	{
	    if (prompts_str[ind]=='\n') 
	    {
                    PROMPT[i][j]='\0';
                    i++;
                    j=0;
	    } else
	    {
                    PROMPT[i][j]=prompts_str[ind];
                    j++;
	    }
	}

        for (i=0; i<MAXPLAYERS; i++)
	{
                if (strcmp(app_data.name[i],"")==0)
		{
                sprintf(defaultname[i],"%s %d", PROMPT[PLAYER], i+1);
		}
                else
		{
                strcpy(defaultname[i],app_data.name[i]);
		}
	}

	if (app_data.version == 0)
	{
		fprintf(stderr,"Couldn't find resource file %s.\n",app_def_file);
		exit(1);
	} else
	        if (app_data.version != VERSION)
	{
	        fprintf(stderr,
 "Incompatible app-default %s file: v%1.2f versus v%1.2f program!\n", app_def_file,
         (float)app_data.version/100, (float)VERSION/100);
		exit(1);
	}
	
	for (i=0; i<MAXPLAYERS; i++)
		type[i]=app_data.t[i];
	
	num_players=app_data.players;
	time_limit=app_data.timelim;
        bell_level=app_data.bell;

	for (i=0; i<num_players; i++)
	{
		dpy[i] = XtOpenDisplay(app_context,app_data.disp[i],argv[0],app_def_file,
			NULL,0,&argc, argv); 
		if (dpy[i] == NULL)
		{
			printf("Can't open display %s\n",app_data.disp[i]);
			exit(1);
		}
		
		/* check for any computer players */
		if (app_data.t[i]>0)
		    any_comp=True;
	}

	loaddict();
        /* loadrules(); */

	if (any_comp)
	    makeperm(perms, factorial);

	clearboard(cboard);
	clearboard(board);
	makebag();
	shufflebag();

	for (i=0; i<num_players; i++)
	{
		player[i].score=0;
                strcpy(player[i].name, defaultname[i]);

		topl[i] =  XtVaAppCreateShell("topl",app_def_file,
			applicationShellWidgetClass,dpy[i],NULL);

                strcat(defaultname[i],"   ");
                if (type[i]==0)
		{
                strcat(defaultname[i],PROMPT[HUMAN]);
		}
                else
		{
                strcat(defaultname[i],PROMPT[COMPUTER]);
                defaultname[i][strlen(defaultname[i])-2]='0'+type[i];
		}

		XtVaSetValues(topl[i],XtNtitle,defaultname[i],NULL);

		load_data_pixmap(slate_green_xpm,&bgxpm,topl[i]);

		set_board(topl[i],i);
		set_icon_pixmap(xscrabble_xpm,topl[i]);
		acceptQuitPre(topl[i]);
		XtRealizeWidget(topl[i]);
		acceptQuitPost(topl[i]);
	}

	for (i=0; i<num_players; i++)
		XDefineCursor(dpy[i],XtWindow(topl[i]),
			XCreateFontCursor(dpy[i],XC_left_ptr));


	/* select starting player */
	curr_player=rand()%num_players;

	if (app_data.load)
	{
		loadgame();
		InitGame();
	} else
	{
        sprintf(mess,PROMPT[SORTED_OUT],player[curr_player].name);
        for(i=0; i<num_players; i++) if (i!=curr_player) MessageOne(i,mess);
        sprintf(mess,PROMPT[READY],player[curr_player].name);
        MessageOne(curr_player,mess);
	}

        TilesLeft();		

	XtAppMainLoop(app_context);
}

