/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ActiveOperationsMonitorEntry
extends MonitorEntry {
    static final String ACTIVE_OPERATIONS_MONITOR_OC = "ds-active-operations-monitor-entry";
    private static final String ATTR_NUM_OPS_IN_PROGRESS = "num-operations-in-progress";
    private static final String ATTR_NUM_PSEARCHES_IN_PROGRESS = "num-persistent-searches-in-progress";
    private static final String ATTR_OP_IN_PROGRESS = "operation-in-progress";
    private static final String ATTR_PSEARCH_IN_PROGRESS = "persistent-search-in-progress";
    private static final long serialVersionUID = -6583987693176406802L;
    private final List<String> activeOperations = this.getStrings("operation-in-progress");
    private final List<String> activePersistentSearches = this.getStrings("persistent-search-in-progress");
    private final Long numOpsInProgress = this.getLong("num-operations-in-progress");
    private final Long numPsearchesInProgress = this.getLong("num-persistent-searches-in-progress");

    public ActiveOperationsMonitorEntry(Entry entry) {
        super(entry);
    }

    public Long getNumOperationsInProgress() {
        return this.numOpsInProgress;
    }

    public List<String> getActiveOperations() {
        return this.activeOperations;
    }

    public Long getNumPersistentSearchesInProgress() {
        return this.numPsearchesInProgress;
    }

    public List<String> getActivePersistentSearches() {
        return this.activePersistentSearches;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_ACTIVE_OPERATIONS_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_ACTIVE_OPERATIONS_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(4);
        if (this.numOpsInProgress != null) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_OPS_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_NUM_OPS_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_NUM_OPS_IN_PROGRESS.get(), this.numOpsInProgress);
        }
        if (!this.activeOperations.isEmpty()) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_OP_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_OPS_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_OPS_IN_PROGRESS.get(), this.activeOperations);
        }
        if (this.numPsearchesInProgress != null) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_PSEARCHES_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_NUM_PSEARCHES_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_NUM_PSEARCHES_IN_PROGRESS.get(), this.numPsearchesInProgress);
        }
        if (!this.activePersistentSearches.isEmpty()) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_PSEARCH_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_PSEARCHES_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_PSEARCHES_IN_PROGRESS.get(), this.activePersistentSearches);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

