/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform;

import java.util.Collections;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.transform.chain.ChainTransform;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransform;

public final class TransformBuilders {
    private TransformBuilders() {
    }

    public static SearchTransform.Builder searchTransform(WatcherSearchTemplateRequest request) {
        return SearchTransform.builder(request);
    }

    public static ScriptTransform.Builder scriptTransform(String script) {
        return TransformBuilders.scriptTransform(new Script(ScriptType.INLINE, "painless", script, Collections.emptyMap()));
    }

    public static ScriptTransform.Builder scriptTransform(Script script) {
        return ScriptTransform.builder(script);
    }

    public static ChainTransform.Builder chainTransform(Transform.Builder<?> ... transforms) {
        return ChainTransform.builder((Transform[])new Transform[0]).add(transforms);
    }

    public static ChainTransform.Builder chainTransform(Transform ... transforms) {
        return ChainTransform.builder((Transform[])transforms);
    }
}

