/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.idp;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.idp.action.SamlMetadataResponse;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdPMetadataBuilder;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Element;

public class SamlMetadataGenerator {
    private final SamlFactory samlFactory;
    private final SamlIdentityProvider idp;
    private final Logger logger = LogManager.getLogger(SamlMetadataGenerator.class);

    public SamlMetadataGenerator(SamlFactory samlFactory, SamlIdentityProvider idp) {
        this.samlFactory = samlFactory;
        this.idp = idp;
        SamlInit.initialize();
    }

    public void generateMetadata(String spEntityId, String acs, ActionListener<SamlMetadataResponse> listener) {
        this.idp.resolveServiceProvider(spEntityId, acs, true, (ActionListener<SamlServiceProvider>)ActionListener.wrap(sp -> {
            try {
                if (null == sp) {
                    listener.onFailure((Exception)new IllegalArgumentException("Service provider with Entity ID [" + spEntityId + "] is not registered with this Identity Provider"));
                    return;
                }
                EntityDescriptor metadata = this.buildEntityDescriptor((SamlServiceProvider)sp);
                X509Credential signingCredential = this.idp.getMetadataSigningCredential();
                Element metadataElement = this.possiblySignDescriptor(metadata, signingCredential);
                listener.onResponse((Object)new SamlMetadataResponse(this.samlFactory.toString(metadataElement, false)));
            }
            catch (Exception e) {
                this.logger.debug("Error generating IDP metadata to share with [" + spEntityId + "]", (Throwable)e);
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    EntityDescriptor buildEntityDescriptor(SamlServiceProvider sp) throws Exception {
        SamlIdPMetadataBuilder builder = new SamlIdPMetadataBuilder(this.idp.getEntityId()).wantAuthnRequestsSigned(sp.shouldSignAuthnRequests()).withSingleSignOnServiceUrl("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", this.idp.getSingleSignOnEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")).withSingleSignOnServiceUrl("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", this.idp.getSingleSignOnEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")).withSingleLogoutServiceUrl("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", this.idp.getSingleLogoutEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")).withSingleLogoutServiceUrl("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", this.idp.getSingleLogoutEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")).withNameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent").withNameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient").organization(this.idp.getOrganization()).withContact(this.idp.getTechnicalContact());
        X509Credential signingCredential = this.idp.getSigningCredential();
        if (null != signingCredential) {
            builder.withSigningCertificate(signingCredential.getEntityCertificate());
        }
        return builder.build();
    }

    Element possiblySignDescriptor(EntityDescriptor descriptor, X509Credential signingCredential) throws MarshallingException, SignatureException {
        EntityDescriptorMarshaller marshaller = new EntityDescriptorMarshaller();
        if (null == signingCredential) {
            return marshaller.marshall((XMLObject)descriptor);
        }
        Signature signature = this.samlFactory.buildObject(Signature.class, Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)signingCredential);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        descriptor.setSignature(signature);
        Element element = new EntityDescriptorMarshaller().marshall((XMLObject)descriptor);
        Signer.signObject((Signature)signature);
        return element;
    }
}

