/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

final class RequestDispatcher {
    static final Version GROUP_REQUESTS_VERSION = Version.V_7_16_0;
    static final Logger LOGGER = LogManager.getLogger(RequestDispatcher.class);
    private final TransportService transportService;
    private final ClusterState clusterState;
    private final FieldCapabilitiesRequest fieldCapsRequest;
    private final Task parentTask;
    private final OriginalIndices originalIndices;
    private final long nowInMillis;
    private final boolean hasFilter;
    private final Executor executor;
    private final Consumer<FieldCapabilitiesIndexResponse> onIndexResponse;
    private final BiConsumer<String, Exception> onIndexFailure;
    private final Runnable onComplete;
    private final AtomicInteger pendingRequests = new AtomicInteger();
    private final AtomicInteger executionRound = new AtomicInteger();
    private final Map<String, IndexSelector> indexSelectors;

    RequestDispatcher(ClusterService clusterService, TransportService transportService, Task parentTask, FieldCapabilitiesRequest fieldCapsRequest, OriginalIndices originalIndices, long nowInMillis, String[] indices, Executor executor, Consumer<FieldCapabilitiesIndexResponse> onIndexResponse, BiConsumer<String, Exception> onIndexFailure, Runnable onComplete) {
        this.transportService = transportService;
        this.fieldCapsRequest = fieldCapsRequest;
        this.parentTask = parentTask;
        this.originalIndices = originalIndices;
        this.nowInMillis = nowInMillis;
        this.clusterState = clusterService.state();
        this.hasFilter = fieldCapsRequest.indexFilter() != null && !(fieldCapsRequest.indexFilter() instanceof MatchAllQueryBuilder);
        this.executor = executor;
        this.onIndexResponse = onIndexResponse;
        this.onIndexFailure = onIndexFailure;
        this.onComplete = new RunOnce(onComplete);
        this.indexSelectors = ConcurrentCollections.newConcurrentMap();
        for (String index : indices) {
            GroupShardsIterator<ShardIterator> shardIts = clusterService.operationRouting().searchShards(this.clusterState, new String[]{index}, null, null, null, null);
            IndexSelector indexResult = new IndexSelector(shardIts);
            if (indexResult.nodeToShards.isEmpty()) {
                onIndexFailure.accept(index, new NoShardAvailableActionException(null, "index [" + index + "] has no active shard copy"));
                continue;
            }
            this.indexSelectors.put(index, indexResult);
        }
    }

    void execute() {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                ArrayList failedIndices = new ArrayList(RequestDispatcher.this.indexSelectors.keySet());
                for (String failedIndex : failedIndices) {
                    IndexSelector removed = (IndexSelector)RequestDispatcher.this.indexSelectors.remove(failedIndex);
                    assert (removed != null);
                    RequestDispatcher.this.onIndexFailure.accept(failedIndex, e);
                }
                RequestDispatcher.this.onComplete.run();
            }

            @Override
            protected void doRun() {
                RequestDispatcher.this.innerExecute();
            }
        });
    }

    private void innerExecute() {
        HashMap<String, List> nodeToSelectedShards = new HashMap<String, List>();
        assert (this.pendingRequests.get() == 0) : "pending requests = " + this.pendingRequests;
        ArrayList<String> failedIndices = new ArrayList<String>();
        for (Map.Entry<String, IndexSelector> entry : this.indexSelectors.entrySet()) {
            String index = entry.getKey();
            IndexSelector indexSelector = entry.getValue();
            List<ShardRouting> selectedShards = indexSelector.nextTarget(this.clusterState.nodes(), this.hasFilter);
            if (selectedShards.isEmpty()) {
                failedIndices.add(index);
                continue;
            }
            this.pendingRequests.addAndGet(selectedShards.size());
            for (ShardRouting shard : selectedShards) {
                nodeToSelectedShards.computeIfAbsent(shard.currentNodeId(), n -> new ArrayList()).add(shard.shardId());
            }
        }
        for (String string : failedIndices) {
            IndexSelector indexSelector = this.indexSelectors.remove(string);
            assert (indexSelector != null);
            Exception failure = indexSelector.getFailure();
            if (failure == null) continue;
            this.onIndexFailure.accept(string, failure);
        }
        if (nodeToSelectedShards.isEmpty()) {
            this.onComplete.run();
        } else {
            for (Map.Entry<String, IndexSelector> entry : nodeToSelectedShards.entrySet()) {
                this.sendRequestToNode(entry.getKey(), (List)((Object)entry.getValue()));
            }
        }
    }

    int executionRound() {
        return this.executionRound.get();
    }

    private void sendRequestToNode(String nodeId, List<ShardId> shardIds) {
        DiscoveryNode node = this.clusterState.nodes().get(nodeId);
        assert (node != null);
        if (node.getVersion().onOrAfter(GROUP_REQUESTS_VERSION)) {
            LOGGER.debug("round {} sends field caps node request to node {} for shardIds {}", (Object)this.executionRound, (Object)node, shardIds);
            ActionListener listener = ActionListener.wrap(r -> this.onRequestResponse(shardIds, (FieldCapabilitiesNodeResponse)r), failure -> this.onRequestFailure(shardIds, (Exception)failure));
            FieldCapabilitiesNodeRequest nodeRequest = new FieldCapabilitiesNodeRequest(shardIds, this.fieldCapsRequest.fields(), this.originalIndices, this.fieldCapsRequest.indexFilter(), this.nowInMillis, this.fieldCapsRequest.runtimeFields());
            this.transportService.sendChildRequest(node, "indices:data/read/field_caps[n]", (TransportRequest)nodeRequest, this.parentTask, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<FieldCapabilitiesNodeResponse>(listener, FieldCapabilitiesNodeResponse::new));
        } else {
            for (ShardId shardId : shardIds) {
                LOGGER.debug("round {} sends field caps shard request to node {} for shardId {}", (Object)this.executionRound, (Object)node, (Object)shardId);
                ActionListener listener = ActionListener.wrap(r -> {
                    FieldCapabilitiesNodeResponse nodeResponse = r.canMatch() ? new FieldCapabilitiesNodeResponse(Collections.singletonList(r), Collections.emptyMap(), Collections.emptySet()) : new FieldCapabilitiesNodeResponse(Collections.emptyList(), Collections.emptyMap(), Collections.singleton(shardId));
                    this.onRequestResponse(Collections.singletonList(shardId), nodeResponse);
                }, e -> this.onRequestFailure(Collections.singletonList(shardId), (Exception)e));
                FieldCapabilitiesIndexRequest shardRequest = new FieldCapabilitiesIndexRequest(this.fieldCapsRequest.fields(), shardId, this.originalIndices, this.fieldCapsRequest.indexFilter(), this.nowInMillis, this.fieldCapsRequest.runtimeFields());
                this.transportService.sendChildRequest(node, "indices:data/read/field_caps[index][s]", (TransportRequest)shardRequest, this.parentTask, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<FieldCapabilitiesIndexResponse>(listener, is -> new FieldCapabilitiesIndexResponse(is, new IndexFieldCapabilities.Deduplicator())));
            }
        }
    }

    private void afterRequestsCompleted(int numRequests) {
        if (this.pendingRequests.addAndGet(-numRequests) == 0) {
            this.executionRound.incrementAndGet();
            this.execute();
        }
    }

    private void onRequestResponse(List<ShardId> shardIds, FieldCapabilitiesNodeResponse nodeResponse) {
        IndexSelector indexSelector;
        for (FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse : nodeResponse.getIndexResponses()) {
            if (!fieldCapabilitiesIndexResponse.canMatch() || this.indexSelectors.remove(fieldCapabilitiesIndexResponse.getIndexName()) == null) continue;
            this.onIndexResponse.accept(fieldCapabilitiesIndexResponse);
        }
        for (ShardId shardId : nodeResponse.getUnmatchedShardIds()) {
            indexSelector = this.indexSelectors.get(shardId.getIndexName());
            if (indexSelector == null) continue;
            indexSelector.addUnmatchedShardId(shardId);
        }
        for (Map.Entry entry : nodeResponse.getFailures().entrySet()) {
            indexSelector = this.indexSelectors.get(((ShardId)entry.getKey()).getIndexName());
            if (indexSelector == null) continue;
            indexSelector.setFailure((ShardId)entry.getKey(), (Exception)entry.getValue());
        }
        this.afterRequestsCompleted(shardIds.size());
    }

    private void onRequestFailure(List<ShardId> shardIds, Exception e) {
        for (ShardId shardId : shardIds) {
            IndexSelector indexSelector = this.indexSelectors.get(shardId.getIndexName());
            if (indexSelector == null) continue;
            indexSelector.setFailure(shardId, e);
        }
        this.afterRequestsCompleted(shardIds.size());
    }

    private static class IndexSelector {
        private final Map<String, List<ShardRouting>> nodeToShards = new HashMap<String, List<ShardRouting>>();
        private final Set<ShardId> unmatchedShardIds = new HashSet<ShardId>();
        private final Map<ShardId, Exception> failures = new HashMap<ShardId, Exception>();

        IndexSelector(GroupShardsIterator<ShardIterator> shardIts) {
            for (ShardIterator shardIt : shardIts) {
                for (ShardRouting shard : shardIt) {
                    this.nodeToShards.computeIfAbsent(shard.currentNodeId(), node -> new ArrayList()).add(shard);
                }
            }
        }

        synchronized Exception getFailure() {
            Exception first = null;
            for (Exception e : this.failures.values()) {
                first = ExceptionsHelper.useOrSuppress(first, e);
            }
            return first;
        }

        synchronized void setFailure(ShardId shardId, Exception failure) {
            assert (!this.unmatchedShardIds.contains(shardId)) : "Shard " + shardId + " was unmatched already";
            this.failures.compute(shardId, (k, curr) -> ExceptionsHelper.useOrSuppress(curr, failure));
        }

        synchronized void addUnmatchedShardId(ShardId shardId) {
            boolean added = this.unmatchedShardIds.add(shardId);
            assert (added) : "Shard " + shardId + " was unmatched already";
            this.failures.remove(shardId);
        }

        synchronized List<ShardRouting> nextTarget(DiscoveryNodes discoveryNodes, boolean withQueryFilter) {
            if (this.nodeToShards.isEmpty()) {
                return Collections.emptyList();
            }
            Iterator<Map.Entry<String, List<ShardRouting>>> nodeIt = this.nodeToShards.entrySet().iterator();
            if (withQueryFilter) {
                ArrayList<ShardRouting> selectedShards = new ArrayList<ShardRouting>();
                HashSet<ShardId> selectedShardIds = new HashSet<ShardId>();
                while (nodeIt.hasNext()) {
                    List<ShardRouting> shards = nodeIt.next().getValue();
                    Iterator<ShardRouting> shardIt = shards.iterator();
                    while (shardIt.hasNext()) {
                        ShardRouting shard = shardIt.next();
                        if (this.unmatchedShardIds.contains(shard.shardId())) {
                            shardIt.remove();
                            continue;
                        }
                        if (!selectedShardIds.add(shard.shardId())) continue;
                        shardIt.remove();
                        selectedShards.add(shard);
                    }
                    if (!shards.isEmpty()) continue;
                    nodeIt.remove();
                }
                return selectedShards;
            }
            assert (this.unmatchedShardIds.isEmpty());
            Map.Entry<String, List<ShardRouting>> node = nodeIt.next();
            DiscoveryNode discoNode = discoveryNodes.get(node.getKey());
            if (discoNode.getVersion().onOrAfter(GROUP_REQUESTS_VERSION)) {
                nodeIt.remove();
                return node.getValue();
            }
            List<ShardRouting> shards = node.getValue();
            ShardRouting selectedShard = shards.remove(0);
            if (shards.isEmpty()) {
                nodeIt.remove();
            }
            return Collections.singletonList(selectedShard);
        }
    }
}

