/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public class PendingReplicationActions
implements Consumer<ReplicationGroup>,
Releasable {
    private final Map<String, Set<RetryableAction<?>>> onGoingReplicationActions = ConcurrentCollections.newConcurrentMap();
    private final ShardId shardId;
    private final ThreadPool threadPool;
    private volatile long replicationGroupVersion = -1L;

    public PendingReplicationActions(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
    }

    public void addPendingAction(String allocationId, RetryableAction<?> replicationAction) {
        Set<RetryableAction<?>> ongoingActionsOnNode = this.onGoingReplicationActions.get(allocationId);
        if (ongoingActionsOnNode != null) {
            ongoingActionsOnNode.add(replicationAction);
            if (!this.onGoingReplicationActions.containsKey(allocationId)) {
                replicationAction.cancel(new IndexShardClosedException(this.shardId, "Replica unavailable - replica could have left ReplicationGroup or IndexShard might have closed"));
            }
        } else {
            replicationAction.cancel(new IndexShardClosedException(this.shardId, "Replica unavailable - replica could have left ReplicationGroup or IndexShard might have closed"));
        }
    }

    public void removeReplicationAction(String allocationId, RetryableAction<?> action) {
        Set<RetryableAction<?>> ongoingActionsOnNode = this.onGoingReplicationActions.get(allocationId);
        if (ongoingActionsOnNode != null) {
            ongoingActionsOnNode.remove(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ReplicationGroup replicationGroup) {
        if (this.isNewerVersion(replicationGroup)) {
            PendingReplicationActions pendingReplicationActions = this;
            synchronized (pendingReplicationActions) {
                if (this.isNewerVersion(replicationGroup)) {
                    this.acceptNewTrackedAllocationIds(replicationGroup.getTrackedAllocationIds());
                    this.replicationGroupVersion = replicationGroup.getVersion();
                }
            }
        }
    }

    private boolean isNewerVersion(ReplicationGroup replicationGroup) {
        return replicationGroup.getVersion() - this.replicationGroupVersion > 0L;
    }

    synchronized void acceptNewTrackedAllocationIds(Set<String> trackedAllocationIds) {
        for (String targetAllocationId : trackedAllocationIds) {
            this.onGoingReplicationActions.putIfAbsent(targetAllocationId, ConcurrentCollections.newConcurrentSet());
        }
        ArrayList toCancel = new ArrayList();
        for (String allocationId : this.onGoingReplicationActions.keySet()) {
            if (trackedAllocationIds.contains(allocationId)) continue;
            toCancel.add(this.onGoingReplicationActions.remove(allocationId));
        }
        this.cancelActions(toCancel, "Replica left ReplicationGroup");
    }

    public synchronized void close() {
        ArrayList toCancel = new ArrayList(this.onGoingReplicationActions.values());
        this.onGoingReplicationActions.clear();
        this.cancelActions(toCancel, "Primary closed.");
    }

    private void cancelActions(ArrayList<Set<RetryableAction<?>>> toCancel, String message) {
        this.threadPool.executor("generic").execute(() -> toCancel.stream().flatMap(Collection::stream).forEach(action -> action.cancel(new IndexShardClosedException(this.shardId, message))));
    }
}

