/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DiffableStringMap
extends AbstractMap<String, String>
implements Diffable<DiffableStringMap> {
    public static final DiffableStringMap EMPTY = new DiffableStringMap(Collections.emptyMap());
    private final Map<String, String> innerMap;

    public static DiffableStringMap readFrom(StreamInput in) throws IOException {
        Map<String, Object> map = in.readMap();
        return map.isEmpty() ? EMPTY : new DiffableStringMap(map);
    }

    DiffableStringMap(Map<String, String> map) {
        this.innerMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.innerMap);
    }

    @Override
    public Diff<DiffableStringMap> diff(DiffableStringMap previousState) {
        if (this.equals(previousState)) {
            return DiffableStringMapDiff.EMPTY;
        }
        ArrayList<String> tempDeletes = new ArrayList<String>();
        for (String key : previousState.keySet()) {
            if (this.containsKey(key)) continue;
            tempDeletes.add(key);
        }
        HashMap<String, String> tempUpserts = new HashMap<String, String>();
        for (Map.Entry<String, String> partIter : this.entrySet()) {
            String beforePart = previousState.get(partIter.getKey());
            if (beforePart == null) {
                tempUpserts.put(partIter.getKey(), partIter.getValue());
                continue;
            }
            if (partIter.getValue().equals(beforePart)) continue;
            tempUpserts.put(partIter.getKey(), partIter.getValue());
        }
        return DiffableStringMap.getDiff(tempDeletes, tempUpserts);
    }

    public static Diff<DiffableStringMap> readDiffFrom(StreamInput in) throws IOException {
        List<String> deletes = in.readStringList();
        Map<String, String> upserts = in.readMap(StreamInput::readString, StreamInput::readString);
        return DiffableStringMap.getDiff(deletes, upserts);
    }

    private static Diff<DiffableStringMap> getDiff(List<String> deletes, Map<String, String> upserts) {
        if (deletes.isEmpty() && upserts.isEmpty()) {
            return DiffableStringMapDiff.EMPTY;
        }
        return new DiffableStringMapDiff(deletes, upserts);
    }

    public static class DiffableStringMapDiff
    implements Diff<DiffableStringMap> {
        public static final DiffableStringMapDiff EMPTY = new DiffableStringMapDiff(Collections.emptyList(), Collections.emptyMap()){

            @Override
            public DiffableStringMap apply(DiffableStringMap part) {
                return part;
            }
        };
        private final List<String> deletes;
        private final Map<String, String> upserts;

        private DiffableStringMapDiff(List<String> deletes, Map<String, String> upserts) {
            this.deletes = deletes;
            this.upserts = upserts;
        }

        public List<String> getDeletes() {
            return this.deletes;
        }

        public Map<String, Diff<String>> getDiffs() {
            return Collections.emptyMap();
        }

        public Map<String, String> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.deletes);
            out.writeMap(this.upserts, StreamOutput::writeString, StreamOutput::writeString);
        }

        @Override
        public DiffableStringMap apply(DiffableStringMap part) {
            HashMap<String, String> builder = new HashMap<String, String>(part.innerMap);
            List<String> deletes = this.getDeletes();
            for (String delete : deletes) {
                builder.remove(delete);
            }
            assert (this.getDiffs().size() == 0) : "there should never be diffs for DiffableStringMap";
            builder.putAll(this.upserts);
            return new DiffableStringMap(builder);
        }
    }
}

