/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ShardAllocationDecision
implements ToXContentFragment,
Writeable {
    public static final ShardAllocationDecision NOT_TAKEN = new ShardAllocationDecision(AllocateUnassignedDecision.NOT_TAKEN, MoveDecision.NOT_TAKEN);
    private final AllocateUnassignedDecision allocateDecision;
    private final MoveDecision moveDecision;

    public ShardAllocationDecision(AllocateUnassignedDecision allocateDecision, MoveDecision moveDecision) {
        this.allocateDecision = allocateDecision;
        this.moveDecision = moveDecision;
    }

    public ShardAllocationDecision(StreamInput in) throws IOException {
        this.allocateDecision = new AllocateUnassignedDecision(in);
        this.moveDecision = new MoveDecision(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.allocateDecision.writeTo(out);
        this.moveDecision.writeTo(out);
    }

    public boolean isDecisionTaken() {
        return this.allocateDecision.isDecisionTaken() || this.moveDecision.isDecisionTaken();
    }

    public AllocateUnassignedDecision getAllocateDecision() {
        return this.allocateDecision;
    }

    public MoveDecision getMoveDecision() {
        return this.moveDecision;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.allocateDecision.isDecisionTaken()) {
            this.allocateDecision.toXContent(builder, params);
        }
        if (this.moveDecision.isDecisionTaken()) {
            this.moveDecision.toXContent(builder, params);
        }
        return builder;
    }
}

