/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public final class TypeFieldType
extends ConstantFieldType {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeFieldType.class);
    public static final String TYPES_V7_DEPRECATION_MESSAGE = "[types removal] Using the _type field in queries and aggregations is deprecated, prefer to use a field instead.";
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";
    private final String type;

    TypeFieldType(String type) {
        super("_type", Collections.emptyMap());
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String typeName() {
        return "_type";
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        deprecationLogger.critical(DeprecationCategory.TYPES, "typefieldtype", TYPES_V7_DEPRECATION_MESSAGE, new Object[0]);
        return new MatchAllDocsQuery();
    }

    @Override
    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        deprecationLogger.critical(DeprecationCategory.TYPES, "typefieldtype", TYPES_V7_DEPRECATION_MESSAGE, new Object[0]);
        return new ConstantIndexFieldData.Builder(this.type, this.name(), CoreValuesSourceType.KEYWORD);
    }

    @Override
    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
    }

    @Override
    protected boolean matches(String pattern, boolean caseInsensitive, SearchExecutionContext context) {
        deprecationLogger.critical(DeprecationCategory.TYPES, "typefieldtype", TYPES_V7_DEPRECATION_MESSAGE, new Object[0]);
        if (caseInsensitive) {
            return pattern.equalsIgnoreCase(this.type);
        }
        return pattern.equals(this.type);
    }
}

