/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.search.stats.FieldUsageStats;
import org.elasticsearch.search.internal.FieldUsageTrackingDirectoryReader;

public class ShardFieldUsageTracker {
    private final Map<String, InternalFieldStats> perFieldStats = new ConcurrentHashMap<String, InternalFieldStats>();

    public FieldUsageStatsTrackingSession createSession() {
        return new FieldUsageStatsTrackingSession();
    }

    public FieldUsageStats stats(String ... fields) {
        HashMap<String, FieldUsageStats.PerFieldUsageStats> stats = new HashMap<String, FieldUsageStats.PerFieldUsageStats>(this.perFieldStats.size());
        for (Map.Entry<String, InternalFieldStats> entry : this.perFieldStats.entrySet()) {
            InternalFieldStats ifs = entry.getValue();
            if (!CollectionUtils.isEmpty(fields) && !Regex.simpleMatch(fields, entry.getKey())) continue;
            FieldUsageStats.PerFieldUsageStats pf = new FieldUsageStats.PerFieldUsageStats(ifs.any.longValue(), ifs.proximity.longValue(), ifs.terms.longValue(), ifs.postings.longValue(), ifs.termFrequencies.longValue(), ifs.positions.longValue(), ifs.offsets.longValue(), ifs.docValues.longValue(), ifs.storedFields.longValue(), ifs.norms.longValue(), ifs.payloads.longValue(), ifs.termVectors.longValue(), ifs.points.longValue());
            stats.put(entry.getKey(), pf);
        }
        return new FieldUsageStats(Collections.unmodifiableMap(stats));
    }

    public class FieldUsageStatsTrackingSession
    implements FieldUsageTrackingDirectoryReader.FieldUsageNotifier,
    Releasable {
        private final Map<String, PerField> usages = new ConcurrentHashMap<String, PerField>();

        public void close() {
            this.usages.entrySet().stream().forEach(e -> {
                InternalFieldStats fieldStats = ShardFieldUsageTracker.this.perFieldStats.computeIfAbsent((String)e.getKey(), f -> new InternalFieldStats());
                PerField pf = (PerField)e.getValue();
                boolean any = false;
                boolean proximity = false;
                if (pf.terms) {
                    any = true;
                    fieldStats.terms.increment();
                }
                if (pf.postings) {
                    any = true;
                    fieldStats.postings.increment();
                }
                if (pf.termFrequencies) {
                    any = true;
                    fieldStats.termFrequencies.increment();
                }
                if (pf.positions) {
                    any = true;
                    proximity = true;
                    fieldStats.positions.increment();
                }
                if (pf.offsets) {
                    any = true;
                    proximity = true;
                    fieldStats.offsets.increment();
                }
                if (pf.docValues) {
                    any = true;
                    fieldStats.docValues.increment();
                }
                if (pf.storedFields) {
                    any = true;
                    fieldStats.storedFields.increment();
                }
                if (pf.norms) {
                    any = true;
                    fieldStats.norms.increment();
                }
                if (pf.payloads) {
                    any = true;
                    proximity = true;
                    fieldStats.payloads.increment();
                }
                if (pf.points) {
                    any = true;
                    fieldStats.points.increment();
                }
                if (pf.termVectors) {
                    any = true;
                    fieldStats.termVectors.increment();
                }
                if (any) {
                    fieldStats.any.increment();
                }
                if (proximity) {
                    fieldStats.proximity.increment();
                }
            });
        }

        private PerField getOrAdd(String fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must be non-null");
            return this.usages.computeIfAbsent(fieldName, k -> new PerField());
        }

        @Override
        public void onTermsUsed(String field) {
            this.getOrAdd((String)field).terms = true;
        }

        @Override
        public void onPostingsUsed(String field) {
            this.getOrAdd((String)field).postings = true;
        }

        @Override
        public void onTermFrequenciesUsed(String field) {
            this.getOrAdd((String)field).termFrequencies = true;
        }

        @Override
        public void onPositionsUsed(String field) {
            this.getOrAdd((String)field).positions = true;
        }

        @Override
        public void onOffsetsUsed(String field) {
            this.getOrAdd((String)field).offsets = true;
        }

        @Override
        public void onDocValuesUsed(String field) {
            this.getOrAdd((String)field).docValues = true;
        }

        @Override
        public void onStoredFieldsUsed(String field) {
            this.getOrAdd((String)field).storedFields = true;
        }

        @Override
        public void onNormsUsed(String field) {
            this.getOrAdd((String)field).norms = true;
        }

        @Override
        public void onPayloadsUsed(String field) {
            this.getOrAdd((String)field).payloads = true;
        }

        @Override
        public void onPointsUsed(String field) {
            this.getOrAdd((String)field).points = true;
        }

        @Override
        public void onTermVectorsUsed(String field) {
            this.getOrAdd((String)field).termVectors = true;
        }
    }

    static class InternalFieldStats {
        final LongAdder any = new LongAdder();
        final LongAdder proximity = new LongAdder();
        final LongAdder terms = new LongAdder();
        final LongAdder postings = new LongAdder();
        final LongAdder termFrequencies = new LongAdder();
        final LongAdder positions = new LongAdder();
        final LongAdder offsets = new LongAdder();
        final LongAdder docValues = new LongAdder();
        final LongAdder storedFields = new LongAdder();
        final LongAdder norms = new LongAdder();
        final LongAdder payloads = new LongAdder();
        final LongAdder termVectors = new LongAdder();
        final LongAdder points = new LongAdder();

        InternalFieldStats() {
        }
    }

    static class PerField {
        volatile boolean terms;
        volatile boolean postings;
        volatile boolean termFrequencies;
        volatile boolean positions;
        volatile boolean offsets;
        volatile boolean docValues;
        volatile boolean storedFields;
        volatile boolean norms;
        volatile boolean payloads;
        volatile boolean termVectors;
        volatile boolean points;

        PerField() {
        }
    }
}

