/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

public class RestAnalyzeAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/_analyze"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_analyze")));
    }

    @Override
    public String getName() {
        return "analyze_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            AnalyzeAction.Request analyzeRequest = AnalyzeAction.Request.fromXContent(parser, request.param("index"));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeAction.Response>((RestChannel)channel));
            return restChannelConsumer;
        }
    }
}

