/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FuzzyOptions
implements ToXContentFragment,
Writeable {
    static final ParseField FUZZY_OPTIONS = new ParseField("fuzzy", new String[0]);
    private static final ParseField TRANSPOSITION_FIELD = new ParseField("transpositions", new String[0]);
    private static final ParseField MIN_LENGTH_FIELD = new ParseField("min_length", new String[0]);
    private static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    private static final ParseField UNICODE_AWARE_FIELD = new ParseField("unicode_aware", new String[0]);
    private static final ParseField MAX_DETERMINIZED_STATES_FIELD = new ParseField("max_determinized_states", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser(FUZZY_OPTIONS.getPreferredName(), Builder::new);
    private int editDistance;
    private boolean transpositions;
    private int fuzzyMinLength;
    private int fuzzyPrefixLength;
    private boolean unicodeAware;
    private int maxDeterminizedStates;

    static FuzzyOptions parse(XContentParser parser) throws IOException {
        return ((Builder)PARSER.parse(parser, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private FuzzyOptions(int editDistance, boolean transpositions, int fuzzyMinLength, int fuzzyPrefixLength, boolean unicodeAware, int maxDeterminizedStates) {
        this.editDistance = editDistance;
        this.transpositions = transpositions;
        this.fuzzyMinLength = fuzzyMinLength;
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        this.unicodeAware = unicodeAware;
        this.maxDeterminizedStates = maxDeterminizedStates;
    }

    FuzzyOptions(StreamInput in) throws IOException {
        this.transpositions = in.readBoolean();
        this.unicodeAware = in.readBoolean();
        this.editDistance = in.readVInt();
        this.fuzzyMinLength = in.readVInt();
        this.fuzzyPrefixLength = in.readVInt();
        this.maxDeterminizedStates = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.transpositions);
        out.writeBoolean(this.unicodeAware);
        out.writeVInt(this.editDistance);
        out.writeVInt(this.fuzzyMinLength);
        out.writeVInt(this.fuzzyPrefixLength);
        out.writeVInt(this.maxDeterminizedStates);
    }

    public int getEditDistance() {
        return this.editDistance;
    }

    public boolean isTranspositions() {
        return this.transpositions;
    }

    public int getFuzzyMinLength() {
        return this.fuzzyMinLength;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public boolean isUnicodeAware() {
        return this.unicodeAware;
    }

    public int getMaxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FuzzyOptions that = (FuzzyOptions)o;
        if (this.editDistance != that.editDistance) {
            return false;
        }
        if (this.transpositions != that.transpositions) {
            return false;
        }
        if (this.fuzzyMinLength != that.fuzzyMinLength) {
            return false;
        }
        if (this.fuzzyPrefixLength != that.fuzzyPrefixLength) {
            return false;
        }
        if (this.unicodeAware != that.unicodeAware) {
            return false;
        }
        return this.maxDeterminizedStates == that.maxDeterminizedStates;
    }

    public int hashCode() {
        int result = this.editDistance;
        result = 31 * result + (this.transpositions ? 1 : 0);
        result = 31 * result + this.fuzzyMinLength;
        result = 31 * result + this.fuzzyPrefixLength;
        result = 31 * result + (this.unicodeAware ? 1 : 0);
        result = 31 * result + this.maxDeterminizedStates;
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(FUZZY_OPTIONS.getPreferredName());
        builder.field(Fuzziness.FIELD.getPreferredName(), this.editDistance);
        builder.field(TRANSPOSITION_FIELD.getPreferredName(), this.transpositions);
        builder.field(MIN_LENGTH_FIELD.getPreferredName(), this.fuzzyMinLength);
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.fuzzyPrefixLength);
        builder.field(UNICODE_AWARE_FIELD.getPreferredName(), this.unicodeAware);
        builder.field(MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareInt(Builder::setFuzzyMinLength, MIN_LENGTH_FIELD);
        PARSER.declareInt(Builder::setMaxDeterminizedStates, MAX_DETERMINIZED_STATES_FIELD);
        PARSER.declareBoolean(Builder::setUnicodeAware, UNICODE_AWARE_FIELD);
        PARSER.declareInt(Builder::setFuzzyPrefixLength, PREFIX_LENGTH_FIELD);
        PARSER.declareBoolean(Builder::setTranspositions, TRANSPOSITION_FIELD);
        PARSER.declareField(Builder::setFuzziness, Fuzziness::parse, Fuzziness.FIELD, ObjectParser.ValueType.VALUE);
    }

    public static class Builder {
        private int editDistance = 1;
        private boolean transpositions = true;
        private int fuzzyMinLength = 3;
        private int fuzzyPrefixLength = 1;
        private boolean unicodeAware = false;
        private int maxDeterminizedStates = 10000;

        public Builder setFuzziness(int editDistance) {
            if (editDistance < 0 || editDistance > 2) {
                throw new IllegalArgumentException("fuzziness must be between 0 and 2");
            }
            this.editDistance = editDistance;
            return this;
        }

        public Builder setFuzziness(Fuzziness fuzziness) {
            Objects.requireNonNull(fuzziness, "fuzziness must not be null");
            return this.setFuzziness(fuzziness.asDistance());
        }

        public Builder setTranspositions(boolean transpositions) {
            this.transpositions = transpositions;
            return this;
        }

        public Builder setFuzzyMinLength(int fuzzyMinLength) {
            if (fuzzyMinLength < 0) {
                throw new IllegalArgumentException("fuzzyMinLength must not be negative");
            }
            this.fuzzyMinLength = fuzzyMinLength;
            return this;
        }

        public Builder setFuzzyPrefixLength(int fuzzyPrefixLength) {
            if (fuzzyPrefixLength < 0) {
                throw new IllegalArgumentException("fuzzyPrefixLength must not be negative");
            }
            this.fuzzyPrefixLength = fuzzyPrefixLength;
            return this;
        }

        public Builder setMaxDeterminizedStates(int maxDeterminizedStates) {
            if (maxDeterminizedStates < 0) {
                throw new IllegalArgumentException("maxDeterminizedStates must not be negative");
            }
            this.maxDeterminizedStates = maxDeterminizedStates;
            return this;
        }

        public Builder setUnicodeAware(boolean unicodeAware) {
            this.unicodeAware = unicodeAware;
            return this;
        }

        public FuzzyOptions build() {
            return new FuzzyOptions(this.editDistance, this.transpositions, this.fuzzyMinLength, this.fuzzyPrefixLength, this.unicodeAware, this.maxDeterminizedStates);
        }
    }
}

