/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;

public class ShapeUtils {
    private ShapeUtils() {
    }

    public static XYPolygon toLuceneXYPolygon(Polygon polygon) {
        XYPolygon[] holes = new XYPolygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new XYPolygon(ShapeUtils.doubleArrayToFloatArray(polygon.getHole(i).getX()), ShapeUtils.doubleArrayToFloatArray(polygon.getHole(i).getY()), new XYPolygon[0]);
        }
        return new XYPolygon(ShapeUtils.doubleArrayToFloatArray(polygon.getPolygon().getX()), ShapeUtils.doubleArrayToFloatArray(polygon.getPolygon().getY()), holes);
    }

    public static XYPolygon toLuceneXYPolygon(Rectangle r) {
        return new XYPolygon(new float[]{(float)r.getMinX(), (float)r.getMaxX(), (float)r.getMaxX(), (float)r.getMinX(), (float)r.getMinX()}, new float[]{(float)r.getMinY(), (float)r.getMinY(), (float)r.getMaxY(), (float)r.getMaxY(), (float)r.getMinY()}, new XYPolygon[0]);
    }

    public static XYRectangle toLuceneXYRectangle(Rectangle r) {
        return new XYRectangle((float)r.getMinX(), (float)r.getMaxX(), (float)r.getMinY(), (float)r.getMaxY());
    }

    public static XYPoint toLuceneXYPoint(Point point) {
        return new XYPoint((float)point.getX(), (float)point.getY());
    }

    public static XYLine toLuceneXYLine(Line line) {
        return new XYLine(ShapeUtils.doubleArrayToFloatArray(line.getX()), ShapeUtils.doubleArrayToFloatArray(line.getY()));
    }

    public static XYCircle toLuceneXYCircle(Circle circle) {
        return new XYCircle((float)circle.getX(), (float)circle.getY(), (float)circle.getRadiusMeters());
    }

    private static float[] doubleArrayToFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }
}

