/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.OfflineSorter;
import org.elasticsearch.common.lucene.store.FilterIndexOutput;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.core.internal.io.IOUtils;

class CompressingOfflineSorter
extends OfflineSorter {
    CompressingOfflineSorter(Directory dir, String tempFileNamePrefix, Comparator<BytesRef> comparator, int ramBufferSizeMB) {
        super(dir, tempFileNamePrefix, comparator, OfflineSorter.BufferSize.megabytes((long)(ramBufferSizeMB / 2)), 2, -1, null, 1);
    }

    public OfflineSorter.ByteSequencesReader getReader(ChecksumIndexInput in, String name) throws IOException {
        long gzipLen = in.length() - (long)CodecUtil.footerLength();
        InflaterInputStream gzipInputStream = new InflaterInputStream((InputStream)new InputStreamIndexInput((IndexInput)in, gzipLen));
        final DataInputStream dataIn = new DataInputStream(gzipInputStream);
        final BytesRefBuilder ref = new BytesRefBuilder();
        return new OfflineSorter.ByteSequencesReader(in, name){

            public BytesRef next() throws IOException {
                int bytesRead;
                int length = this.readShort();
                if (length == -1) {
                    return null;
                }
                ref.grow(length);
                ref.setLength(length);
                for (int readSize = 0; readSize < length; readSize += bytesRead) {
                    bytesRead = dataIn.read(ref.bytes(), readSize, length - readSize);
                }
                return ref.get();
            }

            private short readShort() throws IOException {
                int ch1 = dataIn.read();
                if (ch1 == -1) {
                    return -1;
                }
                int ch2 = dataIn.read();
                short length = (short)((ch1 << 8) + (ch2 << 0));
                assert (length > 0);
                return length;
            }

            public void close() throws IOException {
                IOUtils.close((Closeable)dataIn);
                super.close();
            }
        };
    }

    public Writer getWriter(IndexOutput out, long itemCount) throws IOException {
        DeflaterOutputStream gzipOut = new DeflaterOutputStream((OutputStream)new IndexOutputOutputStream(out), true);
        final DataOutputStream dataOut = new DataOutputStream(gzipOut);
        return new Writer((IndexOutput)new FlushIndexOutput(out.getName(), out, gzipOut)){

            public void write(byte[] bytes, int off, int len) throws IOException {
                assert (bytes != null);
                assert (off >= 0 && off + len <= bytes.length);
                assert (len >= 0);
                if (len > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("len must be <= 32767; got " + len);
                }
                dataOut.writeShort((short)len);
                dataOut.write(bytes, off, len);
            }

            public void close() throws IOException {
                IOUtils.close((Closeable)dataOut);
                super.close();
            }
        };
    }

    private static class FlushIndexOutput
    extends FilterIndexOutput {
        final DeflaterOutputStream gzip;
        boolean finished = false;

        private FlushIndexOutput(String resourceDescription, IndexOutput out, DeflaterOutputStream gzip) {
            super(resourceDescription, out);
            this.gzip = gzip;
        }

        public void writeByte(byte b) throws IOException {
            if (!this.finished) {
                this.gzip.finish();
                this.finished = true;
            }
            this.out.writeByte(b);
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (!this.finished) {
                this.gzip.finish();
                this.finished = true;
            }
            this.out.writeBytes(b, offset, length);
        }
    }

    static class Writer
    extends OfflineSorter.ByteSequencesWriter {
        final IndexOutput out;

        Writer(IndexOutput out) {
            super(out);
            this.out = out;
        }
    }
}

