/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.AllocationInfo;

public class AllocationRoutedStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-allocation";
    private static final Logger logger = LogManager.getLogger(AllocationRoutedStep.class);

    AllocationRoutedStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata idxMeta = clusterState.metadata().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        if (!ActiveShardCount.ALL.enoughShardsActive(clusterState, new String[]{index.getName()})) {
            logger.debug("[{}] lifecycle action for index [{}] cannot make progress because not all shards are active", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, AllocationInfo.waitingForActiveShardsAllocationInfo(idxMeta.getNumberOfReplicas()));
        }
        AllocationDeciders allocationDeciders = new AllocationDeciders(Collections.singletonList(new FilterAllocationDecider(clusterState.getMetadata().settings(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))));
        int allocationPendingAllShards = AllocationRoutedStep.getPendingAllocations(index, allocationDeciders, clusterState);
        if (allocationPendingAllShards > 0) {
            logger.debug("{} lifecycle action [{}] waiting for [{}] shards to be allocated to nodes matching the given filters", (Object)index, (Object)this.getKey().getAction(), (Object)allocationPendingAllShards);
            return new ClusterStateWaitStep.Result(false, AllocationInfo.allShardsActiveAllocationInfo(idxMeta.getNumberOfReplicas(), allocationPendingAllShards));
        }
        logger.debug("{} lifecycle action for [{}] complete", (Object)index, (Object)this.getKey().getAction());
        return new ClusterStateWaitStep.Result(true, null);
    }

    static int getPendingAllocations(Index index, AllocationDeciders allocationDeciders, ClusterState clusterState) {
        RoutingAllocation allocation = new RoutingAllocation(allocationDeciders, clusterState.getRoutingNodes(), clusterState, null, null, System.nanoTime());
        int allocationPendingAllShards = 0;
        ImmutableOpenIntMap allShards = clusterState.getRoutingTable().index(index).getShards();
        for (ObjectCursor shardRoutingTable : allShards.values()) {
            for (ShardRouting shardRouting : ((IndexShardRoutingTable)shardRoutingTable.value).shards()) {
                boolean canRemainOnCurrentNode;
                String currentNodeId = shardRouting.currentNodeId();
                boolean bl = canRemainOnCurrentNode = allocationDeciders.canRemain(shardRouting, clusterState.getRoutingNodes().node(currentNodeId), allocation).type() == Decision.Type.YES;
                if (canRemainOnCurrentNode && shardRouting.started()) continue;
                ++allocationPendingAllShards;
            }
        }
        return allocationPendingAllShards;
    }
}

