/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class CreateSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "create-snapshot";
    private static final Logger logger = LogManager.getLogger(CreateSnapshotStep.class);
    private final Step.StepKey nextKeyOnComplete;
    private final Step.StepKey nextKeyOnIncomplete;
    private final SetOnce<Boolean> onResponseResult;

    public CreateSnapshotStep(Step.StepKey key, Step.StepKey nextKeyOnComplete, Step.StepKey nextKeyOnIncomplete, Client client) {
        super(key, null, client);
        this.nextKeyOnComplete = nextKeyOnComplete;
        this.nextKeyOnIncomplete = nextKeyOnIncomplete;
        this.onResponseResult = new SetOnce();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(final IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Void> listener) {
        this.createSnapshot(indexMetadata, new ActionListener<Boolean>(){

            public void onResponse(Boolean complete) {
                CreateSnapshotStep.this.onResponseResult.set((Object)complete);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof InvalidSnapshotNameException && e.getMessage() != null) {
                    if (e.getMessage().endsWith("snapshot with the same name already exists") || e.getMessage().endsWith("snapshot with the same name is already in-progress")) {
                        logger.warn("snapshot [{}] is already in-progress or in-use for index [{}], ILM will attempt to clean it up and recreate it", (Object)((InvalidSnapshotNameException)e).getSnapshotName(), (Object)indexMetadata.getIndex().getName());
                        this.onResponse(false);
                    } else {
                        listener.onFailure(e);
                    }
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void createSnapshot(IndexMetadata indexMetadata, ActionListener<Boolean> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String snapshotRepository = lifecycleState.getSnapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.getSnapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        CreateSnapshotRequest request = new CreateSnapshotRequest(snapshotRepository, snapshotName);
        request.indices(new String[]{indexName});
        request.waitForCompletion(true);
        request.includeGlobalState(false);
        request.masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().admin().cluster().createSnapshot(request, ActionListener.wrap(response -> {
            logger.debug("create snapshot response for policy [{}] and index [{}] is: {}", (Object)policyName, (Object)indexName, (Object)Strings.toString((ToXContent)response));
            SnapshotInfo snapInfo = response.getSnapshotInfo();
            if (snapInfo.failedShards() == 0) {
                listener.onResponse((Object)true);
            } else {
                int failures = snapInfo.failedShards();
                int total = snapInfo.totalShards();
                String message = String.format(Locale.ROOT, "failed to create snapshot successfully, %s failures out of %s total shards failed", failures, total);
                logger.warn(message);
                listener.onResponse((Object)false);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public final Step.StepKey getNextStepKey() {
        if (this.onResponseResult.get() == null) {
            throw new IllegalStateException("cannot call getNextStepKey before performAction");
        }
        return (Boolean)this.onResponseResult.get() != false ? this.nextKeyOnComplete : this.nextKeyOnIncomplete;
    }

    Step.StepKey getNextKeyOnIncomplete() {
        return this.nextKeyOnIncomplete;
    }

    Step.StepKey getNextKeyOnComplete() {
        return this.nextKeyOnComplete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateSnapshotStep that = (CreateSnapshotStep)o;
        return Objects.equals(this.nextKeyOnComplete, that.nextKeyOnComplete) && Objects.equals(this.nextKeyOnIncomplete, that.nextKeyOnIncomplete);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextKeyOnComplete, this.nextKeyOnIncomplete);
    }
}

