/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.inference.results.ClassificationFeatureImportance;
import org.elasticsearch.xpack.core.ml.inference.results.RegressionFeatureImportance;

public class LegacyFeatureImportance
implements Writeable {
    private final List<ClassImportance> classImportance;
    private final double importance;
    private final String featureName;

    public static LegacyFeatureImportance fromClassification(ClassificationFeatureImportance classificationFeatureImportance) {
        return new LegacyFeatureImportance(classificationFeatureImportance.getFeatureName(), classificationFeatureImportance.getTotalImportance(), classificationFeatureImportance.getClassImportance().stream().map(classImportance -> new ClassImportance(classImportance.getClassName(), classImportance.getImportance())).collect(Collectors.toList()));
    }

    public static LegacyFeatureImportance fromRegression(RegressionFeatureImportance regressionFeatureImportance) {
        return new LegacyFeatureImportance(regressionFeatureImportance.getFeatureName(), regressionFeatureImportance.getImportance(), null);
    }

    LegacyFeatureImportance(String featureName, double importance, List<ClassImportance> classImportance) {
        this.featureName = Objects.requireNonNull(featureName);
        this.importance = importance;
        this.classImportance = classImportance == null ? null : Collections.unmodifiableList(classImportance);
    }

    public LegacyFeatureImportance(StreamInput in) throws IOException {
        this.featureName = in.readString();
        this.importance = in.readDouble();
        if (in.readBoolean()) {
            if (in.getVersion().before(Version.V_7_10_0)) {
                Map classImportance = in.readMap(StreamInput::readString, StreamInput::readDouble);
                this.classImportance = ClassImportance.fromMap(classImportance);
            } else {
                this.classImportance = in.readList(ClassImportance::new);
            }
        } else {
            this.classImportance = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeDouble(this.importance);
        out.writeBoolean(this.classImportance != null);
        if (this.classImportance != null) {
            if (out.getVersion().before(Version.V_7_10_0)) {
                out.writeMap(ClassImportance.toMap(this.classImportance), StreamOutput::writeString, StreamOutput::writeDouble);
            } else {
                out.writeList(this.classImportance);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LegacyFeatureImportance that = (LegacyFeatureImportance)object;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.importance, that.importance) && Objects.equals(this.classImportance, that.classImportance);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.importance, this.classImportance);
    }

    public RegressionFeatureImportance forRegression() {
        assert (this.classImportance == null);
        return new RegressionFeatureImportance(this.featureName, this.importance);
    }

    public ClassificationFeatureImportance forClassification() {
        assert (this.classImportance != null);
        return new ClassificationFeatureImportance(this.featureName, this.classImportance.stream().map(aClassImportance -> new ClassificationFeatureImportance.ClassImportance(((ClassImportance)aClassImportance).className, ((ClassImportance)aClassImportance).importance)).collect(Collectors.toList()));
    }

    public static class ClassImportance
    implements Writeable {
        private final Object className;
        private final double importance;

        private static ClassImportance fromMapEntry(Map.Entry<String, Double> entry) {
            return new ClassImportance(entry.getKey(), entry.getValue());
        }

        private static List<ClassImportance> fromMap(Map<String, Double> classImportanceMap) {
            return classImportanceMap.entrySet().stream().map(ClassImportance::fromMapEntry).collect(Collectors.toList());
        }

        private static Map<String, Double> toMap(List<ClassImportance> importances) {
            return importances.stream().collect(Collectors.toMap(i -> i.className.toString(), i -> i.importance));
        }

        public ClassImportance(Object className, double importance) {
            this.className = className;
            this.importance = importance;
        }

        public ClassImportance(StreamInput in) throws IOException {
            this.className = in.readGenericValue();
            this.importance = in.readDouble();
        }

        double getImportance() {
            return this.importance;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.className);
            out.writeDouble(this.importance);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassImportance that = (ClassImportance)o;
            return Double.compare(that.importance, this.importance) == 0 && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.importance);
        }
    }
}

