/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.snapshot.upgrade;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.utils.MemoryTrackedTaskState;

public enum SnapshotUpgradeState implements Writeable,
MemoryTrackedTaskState
{
    LOADING_OLD_STATE,
    SAVING_NEW_STATE,
    STOPPED,
    FAILED;


    public static SnapshotUpgradeState fromString(String name) {
        return SnapshotUpgradeState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static SnapshotUpgradeState fromStream(StreamInput in) throws IOException {
        return (SnapshotUpgradeState)in.readEnum(SnapshotUpgradeState.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isNoneOf(SnapshotUpgradeState ... candidates) {
        return Arrays.stream(candidates).noneMatch(candidate -> this == candidate);
    }

    @Override
    public boolean consumesMemory() {
        return this.isNoneOf(FAILED, STOPPED);
    }
}

