/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.rolemapping;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;

public class GetRoleMappingsResponse
extends ActionResponse {
    private ExpressionRoleMapping[] mappings;

    public GetRoleMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.mappings = new ExpressionRoleMapping[size];
        for (int i = 0; i < size; ++i) {
            this.mappings[i] = new ExpressionRoleMapping(in);
        }
    }

    public GetRoleMappingsResponse(ExpressionRoleMapping ... mappings) {
        this.mappings = mappings;
    }

    public ExpressionRoleMapping[] mappings() {
        return this.mappings;
    }

    public boolean hasMappings() {
        return this.mappings.length > 0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.length);
        for (ExpressionRoleMapping mapping : this.mappings) {
            mapping.writeTo(out);
        }
    }
}

