/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

class StoreKeyConfig
extends KeyConfig {
    private static final String KEYSTORE_FILE = "keystore";
    final String keyStorePath;
    final String keyStoreType;
    final SecureString keyStorePassword;
    final String keyStoreAlgorithm;
    final SecureString keyPassword;
    final String trustStoreAlgorithm;

    StoreKeyConfig(String keyStorePath, String keyStoreType, SecureString keyStorePassword, SecureString keyPassword, String keyStoreAlgorithm, String trustStoreAlgorithm) {
        this.keyStorePath = keyStorePath;
        this.keyStoreType = Objects.requireNonNull(keyStoreType, "keystore type must be specified");
        this.keyStorePassword = Objects.requireNonNull(keyStorePassword, "keystore password must be specified").clone();
        this.keyPassword = Objects.requireNonNull(keyPassword).clone();
        this.keyStoreAlgorithm = keyStoreAlgorithm;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        Path ksPath = this.keyStorePath == null ? null : CertParsingUtils.resolvePath(this.keyStorePath, environment);
        try {
            KeyStore ks = this.getStore(ksPath, this.keyStoreType, this.keyStorePassword);
            this.checkKeyStore(ks);
            return CertParsingUtils.keyManager(ks, this.keyPassword.getChars(), this.keyStoreAlgorithm);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw StoreKeyConfig.missingKeyConfigFile(e, KEYSTORE_FILE, ksPath);
        }
        catch (AccessDeniedException e) {
            throw StoreKeyConfig.unreadableKeyConfigFile(e, KEYSTORE_FILE, ksPath);
        }
        catch (AccessControlException e) {
            throw StoreKeyConfig.blockedKeyConfigFile(e, environment, KEYSTORE_FILE, ksPath);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ElasticsearchException("failed to initialize SSL KeyManager", (Throwable)e, new Object[0]);
        }
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        Path ksPath = CertParsingUtils.resolvePath(this.keyStorePath, environment);
        try {
            KeyStore ks = this.getStore(ksPath, this.keyStoreType, this.keyStorePassword);
            return CertParsingUtils.trustManager(ks, this.trustStoreAlgorithm);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw this.missingTrustConfigFile(e, KEYSTORE_FILE, ksPath);
        }
        catch (AccessDeniedException e) {
            throw this.missingTrustConfigFile(e, KEYSTORE_FILE, ksPath);
        }
        catch (AccessControlException e) {
            throw this.blockedTrustConfigFile(e, environment, KEYSTORE_FILE, Collections.singletonList(ksPath));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ElasticsearchException("failed to initialize SSL TrustManager", (Throwable)e, new Object[0]);
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws GeneralSecurityException, IOException {
        KeyStore trustStore = this.getStore(CertParsingUtils.resolvePath(this.keyStorePath, environment), this.keyStoreType, this.keyStorePassword);
        ArrayList<CertificateInfo> certificates = new ArrayList<CertificateInfo>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] chain = trustStore.getCertificateChain(alias);
            if (chain == null) continue;
            for (int i = 0; i < chain.length; ++i) {
                Certificate certificate = chain[i];
                if (!(certificate instanceof X509Certificate)) continue;
                certificates.add(new CertificateInfo(this.keyStorePath, this.keyStoreType, alias, i == 0, (X509Certificate)certificate));
            }
        }
        return certificates;
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.keyStorePath == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(CertParsingUtils.resolvePath(this.keyStorePath, environment));
    }

    @Override
    List<PrivateKey> privateKeys(@Nullable Environment environment) {
        try {
            KeyStore keyStore = this.getStore(environment, this.keyStorePath, this.keyStoreType, this.keyStorePassword);
            ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>();
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                Key key;
                String alias = e.nextElement();
                if (!keyStore.isKeyEntry(alias) || !((key = keyStore.getKey(alias, this.keyPassword.getChars())) instanceof PrivateKey)) continue;
                privateKeys.add((PrivateKey)key);
            }
            return privateKeys;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to list keys", (Throwable)e, new Object[0]);
        }
    }

    private void checkKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return;
        }
        String message = null != this.keyStorePath ? "the keystore [" + this.keyStorePath + "] does not contain a private key entry" : "the configured PKCS#11 token does not contain a private key entry";
        throw new IllegalArgumentException(message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreKeyConfig that = (StoreKeyConfig)o;
        return Objects.equals(this.keyStorePath, that.keyStorePath) && Objects.equals(this.keyStoreType, that.keyStoreType) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.keyStoreAlgorithm, that.keyStoreAlgorithm) && Objects.equals(this.keyPassword, that.keyPassword) && Objects.equals(this.trustStoreAlgorithm, that.trustStoreAlgorithm);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyStorePath, this.keyStoreType, this.keyStorePassword, this.keyStoreAlgorithm, this.keyPassword, this.trustStoreAlgorithm);
    }

    @Override
    public String toString() {
        return "keyStorePath=[" + this.keyStorePath + "], keyStoreType=[" + this.keyStoreType + "], keyStoreAlgorithm=[" + this.keyStoreAlgorithm + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

