/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.transforms.pivot.ScriptConfig;

public abstract class SingleGroupSource
implements Writeable,
ToXContentObject {
    protected static final ParseField FIELD = new ParseField("field", new String[0]);
    protected static final ParseField SCRIPT = new ParseField("script", new String[0]);
    protected static final ParseField MISSING_BUCKET = new ParseField("missing_bucket", new String[0]);
    protected final String field;
    protected final ScriptConfig scriptConfig;
    protected final boolean missingBucket;

    static <T> void declareValuesSourceFields(AbstractObjectParser<? extends SingleGroupSource, T> parser, boolean lenient) {
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScriptConfig.fromXContent(p, lenient), SCRIPT);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MISSING_BUCKET);
        if (!lenient) {
            parser.declareRequiredFieldSet(new String[]{FIELD.getPreferredName(), SCRIPT.getPreferredName()});
        }
    }

    public SingleGroupSource(String field, ScriptConfig scriptConfig, boolean missingBucket) {
        this.field = field;
        this.scriptConfig = scriptConfig;
        this.missingBucket = missingBucket;
    }

    public SingleGroupSource(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        this.scriptConfig = in.getVersion().onOrAfter(Version.V_7_7_0) ? (ScriptConfig)in.readOptionalWriteable(ScriptConfig::new) : null;
        this.missingBucket = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readBoolean() : false;
    }

    ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.field == null && this.scriptConfig == null) {
            validationException = ValidateActions.addValidationError((String)"Required one of fields [field, script], but none were specified.", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        if (this.scriptConfig != null) {
            builder.field(SCRIPT.getPreferredName(), (ToXContent)this.scriptConfig);
        }
        if (this.missingBucket) {
            builder.field(MISSING_BUCKET.getPreferredName(), this.missingBucket);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.field);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeOptionalWriteable((Writeable)this.scriptConfig);
        }
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.missingBucket);
        }
    }

    public abstract Type getType();

    public String getField() {
        return this.field;
    }

    public ScriptConfig getScriptConfig() {
        return this.scriptConfig;
    }

    public boolean getMissingBucket() {
        return this.missingBucket;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SingleGroupSource that = (SingleGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals((Object)this.scriptConfig, (Object)that.scriptConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.scriptConfig, this.missingBucket});
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    @Nullable
    public String getMappingType() {
        return null;
    }

    public static enum Type {
        TERMS(0),
        HISTOGRAM(1),
        DATE_HISTOGRAM(2),
        GEOTILE_GRID(3);

        private final byte id;

        private Type(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public static Type fromId(byte id) {
            switch (id) {
                case 0: {
                    return TERMS;
                }
                case 1: {
                    return HISTOGRAM;
                }
                case 2: {
                    return DATE_HISTOGRAM;
                }
                case 3: {
                    return GEOTILE_GRID;
                }
            }
            throw new IllegalArgumentException("unknown type");
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

