/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.history;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.time.DateFormatter;

public final class HistoryStoreField {
    public static final String INDEX_PREFIX = ".watcher-history-";
    public static final String INDEX_PREFIX_WITH_TEMPLATE = ".watcher-history-13-";
    public static final String INDEX_PREFIX_WITH_TEMPLATE_10 = ".watcher-history-10-";
    private static final DateFormatter indexTimeFormat = DateFormatter.forPattern((String)"yyyy.MM.dd");

    public static String getHistoryIndexNameForTime(ZonedDateTime time, ClusterState state) {
        if (state == null || state.nodes().getMinNodeVersion().onOrAfter(Version.V_7_7_0)) {
            return INDEX_PREFIX_WITH_TEMPLATE + indexTimeFormat.format((TemporalAccessor)time);
        }
        return INDEX_PREFIX_WITH_TEMPLATE_10 + indexTimeFormat.format((TemporalAccessor)time);
    }
}

