/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;

public class MlInitializationService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlInitializationService.class);
    public static final List<String> LEGACY_ML_INDEX_TEMPLATES = Collections.unmodifiableList(Arrays.asList(".ml-anomalies-", ".ml-config", ".ml-inference-000001", ".ml-inference-000002", ".ml-inference-000003", ".ml-meta", ".ml-notifications", ".ml-notifications-000001", ".ml-notifications-000002", ".ml-state", ".ml-stats"));
    private final Client client;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);
    private final AtomicBoolean mlLegacyTemplateDeletionInProgress = new AtomicBoolean(false);
    private final AtomicBoolean checkForLegacyMlTemplates = new AtomicBoolean(true);
    private final MlDailyMaintenanceService mlDailyMaintenanceService;
    private boolean isMaster = false;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client, MlAssignmentNotifier mlAssignmentNotifier) {
        this(client, new MlDailyMaintenanceService(settings, Objects.requireNonNull(clusterService).getClusterName(), threadPool, client, clusterService, mlAssignmentNotifier), clusterService);
    }

    MlInitializationService(Client client, MlDailyMaintenanceService dailyMaintenanceService, final ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.mlDailyMaintenanceService = dailyMaintenanceService;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND, MlInitializationService.this.mlDailyMaintenanceService::setDeleteExpiredDataRequestsPerSecond);
            }

            public void beforeStop() {
                MlInitializationService.this.offMaster();
            }
        });
    }

    public void onMaster() {
        this.mlDailyMaintenanceService.start();
    }

    public void offMaster() {
        this.mlDailyMaintenanceService.stop();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.isMaster && this.isIndexCreationInProgress.compareAndSet(false, true)) {
            AnnotationIndex.createAnnotationsIndexIfNecessary((Client)this.client, (ClusterState)event.state(), (TimeValue)MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT, (ActionListener)ActionListener.wrap(r -> this.isIndexCreationInProgress.set(false), e -> {
                this.isIndexCreationInProgress.set(false);
                logger.error("Error creating ML annotations index or aliases", (Throwable)e);
            }));
        }
        if (this.isMaster && this.checkForLegacyMlTemplates.get() && !this.deleteOneMlLegacyTemplateIfNecessary(event.state())) {
            this.checkForLegacyMlTemplates.set(false);
        }
    }

    private boolean deleteOneMlLegacyTemplateIfNecessary(ClusterState state) {
        if (state.nodes().getMinNodeVersion().before(MlIndexTemplateRegistry.COMPOSABLE_TEMPLATE_SWITCH_VERSION)) {
            return true;
        }
        String templateToDelete = this.nextTemplateToDelete((ImmutableOpenMap<String, IndexTemplateMetadata>)state.getMetadata().getTemplates());
        if (templateToDelete != null) {
            if (!this.mlLegacyTemplateDeletionInProgress.compareAndSet(false, true)) {
                return true;
            }
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteIndexTemplateAction.INSTANCE, (ActionRequest)new DeleteIndexTemplateRequest(templateToDelete), (ActionListener)ActionListener.wrap(r -> {
                this.mlLegacyTemplateDeletionInProgress.set(false);
                logger.debug("Deleted legacy ML index template [{}]", (Object)templateToDelete);
            }, e -> {
                this.mlLegacyTemplateDeletionInProgress.set(false);
                logger.debug((Message)new ParameterizedMessage("Error deleting legacy ML index template [{}]", (Object)templateToDelete), (Throwable)e);
            }));
            return true;
        }
        return false;
    }

    private String nextTemplateToDelete(ImmutableOpenMap<String, IndexTemplateMetadata> legacyTemplates) {
        for (String mlLegacyTemplate : LEGACY_ML_INDEX_TEMPLATES) {
            if (!legacyTemplates.containsKey((Object)mlLegacyTemplate)) continue;
            return mlLegacyTemplate;
        }
        return null;
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }

    public boolean checkForLegacyMlTemplates() {
        return this.checkForLegacyMlTemplates.get();
    }
}

